package Application::Model::Statistics::Hierarchy::User;

use qbit;

use base qw(Application::Model::Statistics::Hierarchy);

__PACKAGE__->model_accessors(
    partner_db => 'Application::Model::PartnerDB',
    users      => 'Application::Model::Users',
);

__PACKAGE__->register_rights(
    [
        {
            name        => 'statistics_hierarchy_user',
            description => d_gettext('Rights to use statistics on products by user'),
            rights      => {
                statistics_view__partner_login => d_gettext('Right to group product statistics by login'),
                statistics_view__user_id       => d_gettext('Right to group product statistics by user id'),
            },
        }
    ]
);

sub entity_fields {
    my ($self) = @_;

    return [
        (
            $self->check_rights('statistics_view__partner_login')
            ? (
                {
                    id    => 'login',
                    label => gettext('Login'),
                    ($self->check_rights('settings_cmd_ucard') ? (type => 'login') : ())
                },
              )
            : ()
        ),
        (
            $self->check_rights('statistics_view__user_id')
            ? (
                {
                    id    => 'id',
                    label => gettext('User&nbsp;ID'),
                    type  => 'straight_number',
                },
              )
            : ()
        ),
    ];
}

TRUE;
