package Application::Model::Statistics::_Utils::LevelOpts;

use qbit;

use base qw(QBit::Class);

__PACKAGE__->mk_accessors(
    qw(
      fields
      fields_rules
      stat_fields
      model_fields
      filter
      filter_rules
      stat_filter
      model_filter
      )
);

sub init {
    my ($self) = @_;

    my ($stat_fields, $model_fields) = $self->get_fields();

    $self->stat_fields($stat_fields);
    $self->model_fields($model_fields);

    my ($stat_filter, $model_filter) = $self->get_filter();

    $self->stat_filter($stat_filter);
    $self->model_filter($model_filter);
}

sub get_fields {
    my ($self) = @_;

    my $fields = $self->fields;
    my $rules  = $self->fields_rules;

    my $stat_fields = {};
    my $model_fields;
    foreach my $field (keys(%$fields)) {
        if (exists($rules->{$field})) {

            if (exists($rules->{$field}{'replace'})) {
                $stat_fields->{$field} = $rules->{$field}{'replace'};
            }

            if (exists($rules->{$field}{'move_to_model'})) {
                $model_fields->{$field} = delete($stat_fields->{$field}) // $fields->{$field};
            }
        } else {
            $stat_fields->{$field} = $fields->{$field};
        }
    }

    return ($stat_fields, $model_fields);
}

sub get_filter {
    my ($self) = @_;

    my $filter = $self->filter;

    my $stat_filter;
    my $model_filter;

    $self->_filter_processing($filter, \$stat_filter, \$model_filter);

    return map {$_ ? ['AND' => $_] : undef} $stat_filter, $model_filter;
}

sub _filter_processing {
    my ($self, $filter, $stat_filter, $model_filter) = @_;

    if (ref($filter) eq 'ARRAY' && $filter->[0] eq 'AND') {
        foreach (@{$filter->[1]}) {
            $self->_filter_processing($_, $stat_filter, $model_filter);
        }

        return TRUE;
    } elsif (ref($filter) eq 'ARRAY' && $filter->[0] eq 'OR') {
        #public_id, tag_id

        push(@$$stat_filter, $filter);

        return TRUE;
    }

    my $has_not = FALSE;

    my $sub_filter = $filter;
    my ($field, $cmp, $value);
    if (ref($filter) eq 'ARRAY' && @$filter == 3) {
        #standart filter
        ($field, $cmp, $value) = @$filter;
    } elsif (ref($filter) eq '') {
        #boolean(true): `adfox_block`
        $field = $filter;
    } elsif (ref($filter) eq 'HASH' && [%$filter]->[0] eq 'NOT') {
        #boolean(false): NOT `adfox_block`
        $field = $filter->{'NOT'}[0];

        $has_not = TRUE;
    } elsif (ref($filter) eq 'HASH') {
        foreach my $f (keys(%$filter)) {
            $self->_filter_processing([$f => '=' => \$filter->{$f}], $stat_filter, $model_filter);
        }

        return TRUE;
    } else {
        throw 'Bad filter: ' . Dumper($filter);
    }

    $self->{'__FILTER_BY_FIELD__'}{$field} = $has_not;

    my $rules = $self->filter_rules;
    if (exists($rules->{$field})) {
        if (exists($rules->{$field}{'replace'})) {
            $sub_filter = $rules->{$field}{'replace'};
        }

        if (exists($rules->{$field}{'move_to_model'})) {
            push(@$$model_filter, $sub_filter // $filter);
        } elsif (exists($rules->{$field}{'remove'})) {
            #nothing
        } else {
            push(@$$stat_filter, $sub_filter // $filter);
        }
    } else {
        push(@$$stat_filter, $filter);
    }

    return TRUE;
}

sub has_filter_by {
    my ($self, $field) = @_;

    return exists($self->{'__FILTER_BY_FIELD__'}{$field});
}

sub has_not_in_filter_by {
    my ($self, $field) = @_;

    return $self->{'__FILTER_BY_FIELD__'}{$field};
}

sub need_join_model {
    my ($self) = @_;

    return defined($self->model_fields) || defined($self->model_filter);
}

TRUE;
