package Application::Model::Statistics::_Utils::Money;

use qbit;

use base qw(QBit::Class);

use PiConstants qw($STAT_MONEY_SCALE);

use Utils::Logger qw(DEBUG);

=begin comment money2float

B<Параметры:> 1) $int 2) $format (string)

B<Возвращаемое значение:> 1) $string

Возвращает отформатированную строку $string, полученную делением $int на 10_000_000_000 и формата $format

money2float(50_000_000_000) = '5.00'

=end comment

=cut

sub money2float {
    my ($self, $money_int, $format) = @_;

    $money_int //= '-';
    $format    //= "%.2f";

    return $money_int ne '-' ? sprintf($format, ($money_int // 0) / $STAT_MONEY_SCALE) : $money_int;
}

=begin comment _get_int

B<Параметры:> 1) $float 2) $int

B<Возвращаемое значение:> 1) $int

Возвращает целое число $int, которое получается с помощью умножения $float
на 10 ** $int (default: 10_000_000_000). Метод выполяет операцию умножения без использования
математики (с помощью работы со строками), чтобы значения float не поменялось.

=end comment

=cut

sub _get_int {
    my ($self, $decimal, $position) = @_;

    $decimal  //= 0;
    $position //= 10;

    throw gettext('Expected real number, but got "%s"', $decimal) unless looks_like_number($decimal);

    # Hack to reset negative numbers (PI-8925)
    if ($decimal < 0) {
        DEBUG(
            sprintf(
                'Expect positive numbers only, but got: %s (model=%s; last http url "%s")',
                $decimal, ref($self), ($ENV{'LAST_HTTP_URL'} // '')
            )
        );
        $decimal = 0;
    }

    my $printed_float = "$decimal";
    $printed_float = sprintf("%.20f", $decimal) if $printed_float =~ 'e-';    # no scientific notation

    if ($printed_float =~ /^(\d+)(?:[.](\d{1,$position}))?/) {
        my $integer  = $1 ? $1 : 0;
        my $fraction = $2 ? $2 : 0;

        return int("$integer$fraction" . '0' x ($position - length($fraction)));
    }

    throw gettext('Expected real number, but got "%s"', $printed_float);
}

TRUE;
