package Application::Model::SystemEvents;

use qbit;

use base qw(QBit::Application::Model);

my $SYSTEM_EVENTS = {};

sub accessor {'system_events'}

sub get_structure_model_accessors {
    return {partner_db => 'Application::Model::PartnerDB',};
}

sub get_all {
    return [sort {$a->{'id'} <=> $b->{'id'}} values %$SYSTEM_EVENTS];
}

sub start {
    my ($self, $type, %opts) = @_;

    throw Exception 'Incorrect type' if !defined($type) || ref($type) || length($type) > 40;

    my $details = {
        user     => $ENV{'USER'},
        pid      => $$,
        hostname => $self->get_option('hostname'),
        %opts,
    };

    my $system_event = {
        type     => $type,
        details  => $details,
        start_dt => curdate(oformat => 'db_time'),
        stop_dt  => undef,
    };

    $system_event->{'id'} =
      $self->partner_db->system_events->add({%$system_event, details => to_json($details, pretty => TRUE)});

    $SYSTEM_EVENTS->{$system_event->{'id'}} = $system_event;

    return $system_event;
}

sub stop {
    my ($self, @ids) = @_;

    throw Exception 'Expected "id"' unless @ids;

    my $cur_date = curdate(oformat => 'db_time');

    $self->partner_db->system_events->edit({id => \@ids}, {stop_dt => $cur_date});

    return map {$_->{'stop_dt'} = $cur_date; $_} delete(@$SYSTEM_EVENTS{@ids});
}

sub post_run {
    my ($self) = @_;

    my @ids = keys(%$SYSTEM_EVENTS);

    $self->stop(@ids) if @ids;
}

TRUE;
