package Application::Model::TNSDict;

use qbit;

use base qw(Application::Model::DBManager::Base);

__PACKAGE__->model_accessors(
    partner_db      => 'Application::Model::PartnerDB::TNSDicts',
    api_balance     => 'Application::Model::API::Yandex::Balance',
    product_manager => 'Application::Model::ProductManager',
);

__PACKAGE__->register_rights(
    [
        {
            name        => 'tns_dict',
            description => d_gettext('Rights to use TNSDict'),
            rights      => {get_tns_dicts => d_gettext('Right to get TNSDicts'),}
        }
    ]
);

__PACKAGE__->abstract_methods(
    qw(
      reset_settings_on_blocks
      _balance_query
      _dict_table
      )
);

sub update {
    my ($self) = @_;

    my %fields = map {$_->name => $_->{'i18n'}} @{$self->_dict_table()->fields()};
    my @need_fields = map {$_, $fields{$_} ? "e$_" : ()} keys(%fields);

    my $balance_data = $self->api_balance->query_catalog($self->_balance_query());
    my @balance_fields = map {s/^.+\.//; $_} @{$balance_data->{'columns'}};

    my @missed_fields = @{arrays_difference(\@need_fields, \@balance_fields)};
    throw gettext('%s: Balance has not returnd required fields %s', ref($self), join(', ', @missed_fields))
      if @missed_fields;

    my @locales = keys(%{$self->get_option('locales', {})});

    my $table = $self->_dict_table();

    my $tmp_table_name = $table->name . '_tmp';
    my $tmp_table      = $self->partner_db->$tmp_table_name;

    $tmp_table->drop(if_exists => TRUE);
    $tmp_table->create(if_not_exists => FALSE);

    $tmp_table->add_multi(
        [
            map {
                my $row     = $_;
                my $balance = {map {$balance_fields[$_] => $row->[$_]} (0 .. @balance_fields - 1)};
                my $pi      = {
                    map {
                        my $f = $_;
                        $f => $fields{$f}
                          ? {map {$_ => $_ eq 'ru' ? $balance->{$f} : $balance->{"e$f"}} @locales}
                          : $balance->{$f}
                      } keys(%fields)
                };
              } @{$balance_data->{'result'}}
        ]
    );

    my $primary_key = $table->primary_key;
    my $field       = $primary_key->[0];

    my $query = $self->partner_db->query->select(
        table  => $table,
        fields => $primary_key,
        filter => [
            $field, 'NOT IN',
            $self->partner_db->query->select(
                table  => $tmp_table,
                fields => $primary_key,
            )
        ]
    );

    my @lost_ids = map {$_->{$field}} @{$query->get_all()};

    $self->reset_settings_on_blocks(\@lost_ids) if @lost_ids;

    $table->swap($tmp_table_name);

    $tmp_table->drop();
    $self->app->kv_store->set('update_' . $self->accessor, curdate(oformat => 'db_time'));
}

TRUE;
