package Application::Model::VIP_Partners;

use qbit;

use base qw(QBit::Application::Model);

use PiConstants qw($ADINSIDE_CLIENT_ID);

sub accessor {'vip_partners'}

=encoding UTF-8

=cut

=head2 get_info

Возвращает arrayref с данными VIP партнеров.

    my $info = $app->vip_partners->get_info();

Это вернет:

    [
        {
            login                  => "microsoft-partner",
            client_id              => 985797,
            available_block_models => [
                "context_on_site_direct",
                "context_on_site_rtb",
                "search_on_site_direct",
                "search_on_site_premium",
            ],
        },
        ...
    ]

=cut

sub get_info {
    my ($self) = @_;

    my $vip_info = [
        {
            login                  => 'm-ru-text',
            client_id              => 486246,
            available_block_models => [
                qw(
                  context_on_site_direct
                  search_on_site_direct
                  search_on_site_premium
                  context_on_site_adblock
                  )
            ],
        },
        {
            login                  => 'gomailru-ads',
            client_id              => 2984581,
            available_block_models => [
                qw(
                  search_on_site_direct
                  search_on_site_mcb
                  search_on_site_premium
                  search_on_site_market
                  context_on_site_adblock
                  )
            ],
        },
        {
            login                  => 'yantest2016',
            client_id              => 8933103,
            available_block_models => [
                qw(
                  mobile_app_rtb
                  )
            ],
        },
        {
            login                  => 'yantestnew2016',
            client_id              => 9143013,
            available_block_models => [
                qw(
                  mobile_app_rtb
                  video_an_site_inpage
                  video_an_site_instream
                  )
            ],
        },
    ];
}

=head2 is_vip_partner_client_id

Возвращает true, если указанный $client_id является Client ID VIP партнера.
Иначе возвращает false. Если указан undef в качестве $client_id, то
возвращает false.

    my $client_id = 985797;
    my $bool = $app->vip_partners->is_vip_partner_client_id($client_id);

=cut

sub is_vip_partner_client_id {
    my ($self, $client_id) = @_;

    return FALSE unless defined($client_id);

    my $clientid2login = {map {$_->{'client_id'} => $_->{'login'}} @{$self->get_info()}};

    return exists($clientid2login->{$client_id});
}

=head2 model_is_available_for_client_id

Возвращает true, если указанный $client_id является VIP и имеет доступ к
моделе $model

    my $model = 'context_on_site_direct';
    my $client_id = 985797;
    my $bool = $app->vip_partners->model_is_available_for_client_id($model, $client_id);

=cut

sub model_is_available_for_client_id {
    my ($self, $model, $client_id) = @_;

    return FALSE unless defined($client_id);

    my $clientid2models = {map {$_->{'client_id'} => $_->{'available_block_models'}} @{$self->get_info()}};

    return in_array($model, $clientid2models->{$client_id} // []);
}

TRUE;
