package Application::Model::ValidatableMixin;

use qbit;

use base qw(QBit::Application::Model);

sub fix_template {
    my ($self, $qv) = @_;

    return $qv->template;
}

sub get_template {
    my ($self, %opts) = @_;

    my $model_fields = $self->get_model_fields();

    my $template = {
        type   => 'hash',
        fields => {},
        extra  => TRUE,
    };

    $opts{'fields'} = {map {$_ => TRUE} @{$opts{fields}}} if ref($opts{'fields'}) eq 'ARRAY';

    foreach my $field (keys(%$model_fields)) {
        next if not exists($model_fields->{$field}{'need_check'});

        next if $opts{'fields'} and not $opts{'fields'}->{$field};

        # fix_template может менять внутренности шаблона,
        # что может повлиять на дальнейшие вызовы валидатора.
        # Так как структура шаблона условно одноуровневая,
        # то вместо клонирования можно использовать его облегчённую версию
        $template->{'fields'}{$field} = {%{$model_fields->{$field}{'need_check'}}};
    }

    $template->{'fields'} = {%{$template->{'fields'}}, %{$opts{'fix'}}} if $opts{'fix'};

    return (
        template => $template,
        pre_run  => sub {
            $self->fix_template(@_);
        },
    );
}

TRUE;
