package Application::Model::Widgets::Widget;

use qbit;

use base qw(QBit::Application::Model);

use Exception::Validation::BadArguments;

__PACKAGE__->abstract_methods(
    qw(
      can_view_as_default
      priority
      type
      title
      check_available
      )
);

__PACKAGE__->mk_accessors(qw(settings is_available));

sub accessor {$_[0]->{'accessor'}}

sub can_delete {TRUE}

sub can_restore {FALSE}

sub check_settings {
    my ($self) = @_;

    my $settings = $self->settings();

    throw Exception::Validation::BadArguments gettext('Type must be "%s"', $self->type())
      if $settings->{'type'} ne $self->type();

    if (defined($settings->{'width'})) {
        throw Exception::Validation::BadArguments gettext('Width must be "full" or "half"')
          unless grep {$settings->{'width'} eq $_} qw(full half);

        throw Exception::Validation::BadArguments gettext('Width must be "%s"', $self->width())
          if !$self->resizable() && $settings->{'width'} ne $self->width();
    }
}

sub get_default_settings {
    my ($self) = @_;

    return {
        type     => $self->type(),
        accessor => $self->accessor(),
    };
}

sub id {
    my ($self) = @_;

    return $self->type;
}

sub is_first {FALSE}

sub resizable {FALSE}

sub set_server_settings {
    my ($self) = @_;

    my $settings = $self->settings();

    $settings->{'deletable'} = $self->can_delete();
    $settings->{'first'}     = $self->is_first();
    $settings->{'resizable'} = $self->resizable();

    if ($settings->{'resizable'}) {
        $settings->{'width'} //= $self->width();
    } else {
        $settings->{'width'} = $self->width();
    }

    $self->settings($settings);
}

sub widget {
    my ($self, $settings) = @_;

    my $widget = $self->new(settings => $settings, is_available => FALSE, app => $self->app);

    $widget->check_settings();

    $widget->check_available();

    return $widget;
}

sub width {'full'}

TRUE;
