package Application::Model::Widgets::Widget::Adfox;

use qbit;

use base qw(Application::Model::Widgets::Widget);

use Exception::Validation::BadArguments;

sub accessor {'widget_adfox'}

__PACKAGE__->register_rights(
    [
        {
            name        => 'widget_adfox',
            description => d_gettext('rights_to_use_widget_adfox'),
            rights      => {widget_adfox_view_as_default => 'widget_adfox_view_as_default',}
        }
    ]
);

sub can_view_as_default {
    $_[0]->check_short_rights('view_as_default');
}

sub check_available {
    my ($self) = @_;

    $self->is_available(TRUE) if $self->check_short_rights('view_as_default');
}

sub priority {20}

sub get_template_key {'Adfox widget'}

sub title {gettext('adfox')}

sub type {'adfox'}

TRUE;
