package Application::Model::Widgets::Widget::DspErrors;

use qbit;

use base qw(Application::Model::Widgets::Widget);

sub accessor {'widget_dsp_errors'}

__PACKAGE__->model_accessors(statistics_dsp_response => 'Application::Model::DSP::StatisticsResponse',);

__PACKAGE__->register_rights(
    [
        {
            name        => 'widget_dsp_errors',
            description => d_gettext('Rights to use widget dsp errors'),
            rights      => {
                widget_dsp_errors_view_as_default => d_gettext('Right to view widget dsp errors as default'),
                widget_dsp_can_delete             => d_gettext('Right to delete widget dsp errors'),
                widget_dsp_is_first               => d_gettext('Right to view widget dsp errors is first'),
            }
        }
    ]
);

sub can_delete {$_[0]->check_rights('widget_dsp_can_delete')}

sub can_view_as_default {
    $_[0]->check_short_rights('view_as_default');
}

sub check_available {
    my ($self) = @_;

    $self->is_available(TRUE)
      if $self->check_short_rights('view_as_default')
          && $self->check_rights('dsp_statistics_responses')
          && $self->statistics_dsp_response->get_statistics(fields => [qw(dsp_id)], limit => 1);
}

sub is_first {$_[0]->check_rights('widget_dsp_is_first')}

sub priority {400}

sub title {gettext('DSP errors')}

sub type {'dsp-errors'}

sub width {'half'}

TRUE;
