package Application::Model::Widgets::Widget::PaymentDisclaimer;

use qbit;

use base qw(Application::Model::Widgets::Widget);

use Exception::Validation::BadArguments;

sub accessor {'widget_payment_disclaimer'}

__PACKAGE__->register_rights(
    [
        {
            name   => 'widget_payment_disclaimer',
            rights => {widget_payment_disclaimer_view_as_default => 'widget_payment_disclaimer_view_as_default',}
        }
    ]
);

sub can_view_as_default {
    $_[0]->check_short_rights('view_as_default');
}

sub check_available {
    my ($self) = @_;

    $self->is_available(TRUE) if $self->check_short_rights('view_as_default');
}

sub priority {550}

sub get_template_key {'Payment disclaimer'}

sub title {gettext('payment_disclaimer_title')}

sub type {'disclaimer-reward'}

TRUE;
