package Application::Model::Widgets::Widget::ProductsSearch;

use qbit;

use base qw(Application::Model::Widgets::Widget);

sub accessor {'widget_product_search'}

__PACKAGE__->model_accessors();

__PACKAGE__->register_rights(
    [
        {
            name        => 'widget_product_search',
            description => d_gettext('Rights to use widget products-search'),
            rights      => {
                widget_product_search_view_as_default => d_gettext('Right to view widget product-search as default'),
                widget_product_search_by__page_id =>
                  d_gettext('Right to view widget products-search "page_id" as default'),
                widget_product_search_by__login => d_gettext('Right to view widget products-search "login" as default'),
                widget_product_search_by__domain =>
                  d_gettext('Right to view widget products-search "domain" as default'),
                widget_product_search_by__bundle_id =>
                  d_gettext('Right to view widget products-search "bundle_id" as default'),
                widget_product_search_by__client_id =>
                  d_gettext('Right to view widget products-search "client_id" as default'),
                widget_product_search_by__pi_id => d_gettext('Right to view widget products-search "pi_id" as default'),
                widget_product_search_by__adfox_login =>
                  d_gettext('Right to view widget products-search "adfox_login" as default'),
            }
        }
    ]
);

my $FIELDS = [
    {
        field        => 'page_id',
        right_search => 'widget_product_search_by__page_id',
        label        => d_gettext('Page ID'),
        redirect     => 1,
    },
    {
        field        => 'login',
        right_search => 'widget_product_search_by__login',
        label        => d_gettext('Login'),
        redirect     => 0,
    },
    {
        field        => 'domain',
        right_search => 'widget_product_search_by__domain',
        label        => d_gettext('Domain'),
        redirect     => 0,
    },
    {
        field        => 'bundle_id',
        right_search => 'widget_product_search_by__bundel_id',
        label        => d_gettext('Bundle ID'),
        redirect     => 0,
    },
    {
        field        => 'client_id',
        right_search => 'widget_product_search_by__client_id',
        label        => d_gettext('Client ID'),
        redirect     => 0,
    },
    {
        field        => 'pi_id',
        right_search => 'widget_product_search_by__pi_id',
        label        => d_gettext('Old Interface ID'),
        redirect     => 1,
    },
    {
        field        => 'adfox_login',
        right_search => 'widget_product_search_by__adfox_login',
        label        => d_gettext('Adfox login'),
        redirect     => 0,
    },
];

sub can_delete {FALSE}

sub can_view_as_default {
    $_[0]->check_short_rights('view_as_default');
}

sub check_available {
    my ($self) = @_;

    $self->is_available(TRUE) if $self->check_short_rights('view_as_default');
}

sub is_first {TRUE}

sub priority {200}

sub set_server_settings {
    my ($self) = @_;

    $self->SUPER::set_server_settings();

    my $settings = $self->settings();

    my @fields =
      map {{field => $_->{'field'}, label => $_->{'label'}->(), redirect => $_->{'redirect'}}}
      grep {$self->check_rights($_->{'right_search'})} @$FIELDS;

    $settings->{'server_settings'}{'fields'} = \@fields;

    $self->settings($settings);
}

sub title {gettext('Products-search')}

sub type {'products-search'}

TRUE;
