package Application::Model::Widgets::Widget::Revenue;

use qbit;

use base qw(Application::Model::Widgets::Widget);

sub accessor {'widget_revenue'}

__PACKAGE__->model_accessors(
    bk_statistics => 'Application::Model::BKStatistics',
    statistics    => 'Application::Model::Statistics',
);

__PACKAGE__->register_rights(
    [
        {
            name        => 'widget_revenue',
            description => d_gettext('Rights to use widget revenue'),
            rights      => {widget_revenue_view_as_default => d_gettext('Right to view widget revenue as default'),}
        }
    ]
);

sub can_delete {FALSE}

sub can_view_as_default {
    $_[0]->check_short_rights('view_as_default');
}

sub check_available {
    my ($self) = @_;

    $self->is_available(TRUE)
      if $self->check_short_rights('view_as_default')
          && $self->bk_statistics->is_available();
}

sub set_server_settings {
    my ($self) = @_;

    $self->SUPER::set_server_settings();

    my $settings = $self->settings();

    $settings->{'server_settings'}{'available_levels'} =
      {payment => 1, additional_income => $self->statistics->get_level('additional_income')->is_available() ? 1 : 0};

    $self->settings($settings);
}

sub is_first {TRUE}

sub priority {300}

sub title {gettext('Revenue')}

sub type {'revenue'}

sub width {'half'}

TRUE;
