package Application::Model::Widgets::Widget::Summary;

use qbit;

use base qw(Application::Model::Widgets::Widget);

sub accessor {'widget_summary'}

__PACKAGE__->model_accessors(
    bk_statistics => 'Application::Model::BKStatistics',
    statistics    => 'Application::Model::Statistics',
);

__PACKAGE__->register_rights(
    [
        {
            name        => 'widget_summary',
            description => d_gettext('Rights to use widget summary'),
            rights      => {widget_summary_view_as_default => d_gettext('Right to view widget summary as default'),}
        }
    ]
);

sub can_restore {TRUE}

sub can_view_as_default {
    $_[0]->check_short_rights('view_as_default');
}

sub check_available {
    my ($self) = @_;

    $self->is_available(TRUE)
      if $self->check_short_rights('view_as_default')
          && $self->bk_statistics->is_available();
}

sub id {
    my ($self) = @_;

    return $self->type;
}

sub priority {350}

sub resizable {TRUE}

sub title {gettext('Summary')}

sub type {'summary'}

TRUE;
