package Application::Model::Widgets::Widget::Welcome;

use qbit;

use base qw(Application::Model::Widgets::Widget);

use Exception::Validation::BadArguments;

sub accessor {'widget_welcome'}

__PACKAGE__->register_rights(
    [
        {
            name        => 'widget_welcome',
            description => d_gettext('Rights to use widget welcome'),
            rights      => {
                widget_welcome_view_as_default        => d_gettext('Right to view widget welcome as default'),
                widget_welcome_view_as_default__dsp   => d_gettext('Right to view widget welcome "DSP" as default'),
                widget_welcome_view_as_default__video => d_gettext('Right to view widget welcome "Video" as default'),
                widget_welcome_view_as_default__an_mobile =>
                  d_gettext('Right to view widget welcome "Mobile" as default'),
                widget_welcome_view_as_default__an_partner =>
                  d_gettext('Right to view widget welcome "AN Partner" as default'),
            }
        }
    ]
);

my $ROLES = [
    {
        role                  => 'dsp',
        right_view_as_default => 'widget_welcome_view_as_default__dsp',
        key                   => 'Welcome widget for dsp partner',
    },
    {
        role                  => 'video',
        right_view_as_default => 'widget_welcome_view_as_default__video',
        key                   => 'Welcome widget for video partner',
    },
    {
        role                  => 'an_mobile',
        right_view_as_default => 'widget_welcome_view_as_default__an_mobile',
        key                   => 'Welcome widget for an mobile partner',
    },
    {
        role                  => 'an_partner',
        right_view_as_default => 'widget_welcome_view_as_default__an_partner',
        key                   => 'Welcome widget for an partner',
    },
    {
        role => 'multi',
        key  => 'Welcome widget for multi roles',
    },
];

my %ROLES = map {$_->{'role'} => $_} @$ROLES;

sub can_view_as_default {
    $_[0]->check_short_rights('view_as_default');
}

sub check_available {
    my ($self) = @_;

    my $app                   = $self->app;
    my $user_id               = $app->get_option('cur_user', {})->{'id'};
    my $came_through_new_form = (
        @{
            $app->partner_db->form_data->get_all(
                'filter' => {'user_id' => $user_id,},
                'limit'  => 1,
            )
          } ? TRUE : FALSE
    );
    if ($came_through_new_form) {
        my %available_widgets =
          map {$_->{'role'} => TRUE}
          grep {exists($_->{'right_view_as_default'}) && $self->check_rights($_->{'right_view_as_default'})} @$ROLES;

        my $role = $self->settings()->{'settings'}{'role'};

        if (keys(%available_widgets) > 1) {
            $self->is_available(TRUE) if $role eq 'multi';
        } else {
            $self->is_available(TRUE) if $available_widgets{$role};
        }
    }
}

sub check_settings {
    my ($self) = @_;

    $self->SUPER::check_settings();

    throw Exception::Validation::BadArguments gettext('Expected "role" in settings')
      unless exists($self->settings->{'settings'}{'role'});
}

sub get_default_settings {
    my ($self) = @_;

    my $type     = $self->type();
    my $accessor = $self->accessor();

    return map {{type => $type, accessor => $accessor, settings => {role => $_->{'role'}},}} @$ROLES;
}

sub id {
    my ($self) = @_;

    return $self->type . '_' . $self->settings->{'settings'}{'role'};
}

sub priority {10}

sub get_template_key {
    my ($self) = @_;

    my $settings = $self->settings();
    return $ROLES{$self->settings()->{'settings'}{'role'}}->{'key'};
}

sub title {gettext('Welcome')}

sub type {'welcome'}

TRUE;
