package Application::Model::YaCategories;

use qbit;

use base qw(Application::Model::DBManager::Base);

sub accessor      {'ya_categories'}
sub db_table_name {'ya_categories'}

__PACKAGE__->model_accessors(
    partner_db  => 'Application::Model::PartnerDB::YaCategories',
    api_balance => 'Application::Model::API::Yandex::Balance'
);

__PACKAGE__->model_fields(
    id        => {db => TRUE, pk      => TRUE, default => TRUE},
    parent_id => {db => TRUE, default => TRUE},
    name      => {db => TRUE, default => TRUE},
);

__PACKAGE__->model_filter(
    db_accessor => 'partner_db',
    fields      => {
        id        => {type => 'number', label => d_gettext('Category ID')},
        parent_id => {type => 'number', label => d_gettext('Parent ID')},
        name      => {type => 'text',   label => d_gettext('Category name')},
    },
);

TRUE;
