package Cron::Methods::AdvNet;

use qbit;
use Utils::Logger qw(ERROR);

use base qw(QBit::Cron::Methods Cron::Methods);

__PACKAGE__->model_accessors(
    agreement_checker        => 'Application::Model::AgreementChecker',
    api_http_bk              => 'QBit::Application::Model::API::Yandex::HTTPBK',
    auto_start               => 'Application::Model::AutoStart',
    auto_stop                => 'Application::Model::AutoStop',
    context_on_site_campaign => 'Application::Model::Product::AN::ContextOnSite::Campaign',
    search_on_site_campaign  => 'Application::Model::Product::AN::SearchOnSite::Campaign',
);

my $page_accessor_context = 'context_on_site_campaign';
my $page_accessor_search  = 'search_on_site_campaign';

sub model_path {'adv_net'}

sub cron_auto_start_context : CRON('10 * * * *') : LOCK : FREQUENCY_LIMIT('1d') : TTL('2h') {
    my ($self, %opts) = @_;

    $self->auto_start->do_auto_start(
        model => $self->context_on_site_campaign,
        products_for_agreement_checker =>
          $self->app->product_manager->get_block_accessors_by_page_n_tag($page_accessor_context, 'can_auto_start'),
        login                      => $opts{'--login'},
        from                       => $opts{'--from'},
        starting_email_subject     => gettext('Autostarting context campaigns'),
        not_starting_email_subject => gettext('Autostarting context campaigns failed'),
        page_ids_to_ignore         => [qw(128845)],
        page_ids                   => $opts{'--page_ids'},
        heartbeat                  => TRUE,
    );

    return TRUE;
}

sub cron_auto_start_search : CRON('20 * * * *') : LOCK : FREQUENCY_LIMIT('1d') : TTL('2h') {
    my ($self, %opts) = @_;

    $self->auto_start->do_auto_start(
        model => $self->search_on_site_campaign,
        products_for_agreement_checker =>
          $self->app->product_manager->get_block_accessors_by_page_n_tag($page_accessor_search, 'can_auto_start'),
        login                      => $opts{'--login'},
        from                       => $opts{'--from'},
        starting_email_subject     => gettext('Autostarting search campaigns'),
        not_starting_email_subject => gettext('Autostarting search campaigns: not starting'),
        page_ids                   => $opts{'--page_ids'},
        heartbeat                  => TRUE,
    );

    return TRUE;
}

sub cron_prepare_auto_stop_context : CRON('0 * * * *') : LOCK : INSTANCES(10) {
    my ($self, %opts) = @_;

    $self->auto_stop->prepare_auto_stop(
        model => $self->context_on_site_campaign,
        products_for_agreement_checker =>
          $self->app->product_manager->get_block_accessors_by_page_n_tag($page_accessor_context, 'can_auto_stop'),
        # page_id mod instances = instance_number
        additional_filter => [{'MOD' => ['owner_id', \$opts{instances}]}, '=', \($opts{instance_number} - 1)],
    );

    return TRUE;
}

sub cron_auto_stop_context : CRON('*/5 * * * *') : LOCK {
    my ($self, %opts) = @_;

    $self->auto_stop->do_auto_stop(
        email_subject => gettext('Autostop context'),
        model         => $self->context_on_site_campaign,
        products_for_agreement_checker =>
          $self->app->product_manager->get_block_accessors_by_page_n_tag($page_accessor_context, 'can_auto_stop'),
    );

    return TRUE;
}

sub cron_prepare_auto_stop_search : CRON('0 * * * *') : LOCK {
    my ($self) = @_;

    $self->auto_stop->prepare_auto_stop(
        model => $self->search_on_site_campaign,
        products_for_agreement_checker =>
          $self->app->product_manager->get_block_accessors_by_page_n_tag($page_accessor_search, 'can_auto_stop'),
    );

    return TRUE;
}

sub cron_auto_stop_search : CRON('*/5 * * * *') : LOCK {
    my ($self) = @_;

    $self->auto_stop->do_auto_stop(
        email_subject => gettext('Autostop search'),
        model         => $self->search_on_site_campaign,
        products_for_agreement_checker =>
          $self->app->product_manager->get_block_accessors_by_page_n_tag($page_accessor_search, 'can_auto_stop'),
    );

    return TRUE;
}

TRUE;
