package Cron::Methods::AdvNetMobile;

use qbit;

use base qw(QBit::Cron::Methods Cron::Methods);

use PiConstants qw($STOP_MOBILE_MAIL);

__PACKAGE__->model_accessors(
    agreement_checker   => 'Application::Model::AgreementChecker',
    api_http_bk         => 'QBit::Application::Model::API::Yandex::HTTPBK',
    auto_start          => 'Application::Model::AutoStart',
    auto_stop           => 'Application::Model::AutoStop',
    mobile_app_settings => 'Application::Model::Product::AN::MobileApp::Settings',
    ssp_seller          => 'Application::Model::Product::SSP::Seller',
);

my $page_accessor_mobile = 'mobile_app_settings';

sub model_path {'adv_net_mobile'}

sub cron_auto_start : CRON('30 * * * *') : LOCK : FREQUENCY_LIMIT('1d') : TTL('2h') {
    my ($self, %opts) = @_;

    $self->auto_start->do_auto_start(
        model => $self->mobile_app_settings,
        products_for_agreement_checker =>
          $self->app->product_manager->get_block_accessors_by_page_n_tag($page_accessor_mobile, 'can_auto_start'),
        login                      => $opts{'--login'},
        from                       => $opts{'--from'},
        starting_email_subject     => gettext('Autostarting mobile applications'),
        not_starting_email_subject => gettext('Autostarting mobile applications: not starting'),
        additional_field           => 'store_id',
        page_ids_to_ignore         => [$self->ssp_seller->get_adv_net_mobile_ssp_page_ids(),],
        page_ids                   => $opts{'--page_ids'},
        heartbeat                  => TRUE,
    );

    return TRUE;
}

sub cron_prepare_auto_stop : CRON('0 * * * *') : LOCK {
    my ($self) = @_;

    $self->auto_stop->prepare_auto_stop(
        model => $self->mobile_app_settings,
        products_for_agreement_checker =>
          $self->app->product_manager->get_block_accessors_by_page_n_tag($page_accessor_mobile, 'can_auto_stop'),
    );

    return TRUE;
}

sub cron_auto_stop : CRON('*/5 * * * *') : LOCK {
    my ($self) = @_;

    $self->auto_stop->do_auto_stop(
        additional_field => 'store_id',
        email            => $STOP_MOBILE_MAIL,
        email_subject    => gettext('Autostop Mobile'),
        model            => $self->mobile_app_settings,
        products_for_agreement_checker =>
          $self->app->product_manager->get_block_accessors_by_page_n_tag($page_accessor_mobile, 'can_auto_stop'),
    );

    return TRUE;
}

TRUE;
