package Cron::Methods::AdvNetVideo;

use qbit;

use base qw(QBit::Cron::Methods Cron::Methods);

__PACKAGE__->model_accessors(
    agreement_checker => 'Application::Model::AgreementChecker',
    auto_start        => 'Application::Model::AutoStart',
    auto_stop         => 'Application::Model::AutoStop',
    partner_db        => 'Application::Model::PartnerDB::VideoAN',
    video_an_site     => 'Application::Model::Page::Video',
);

my $page_accessor_video = 'video_an_site';

sub model_path {'adv_net_video'}

sub cron_auto_start : CRON('40 * * * *') : LOCK : FREQUENCY_LIMIT('1d') : TTL('2h') {
    my ($self, %opts) = @_;

    $self->auto_start->do_auto_start(
        model => $self->video_an_site,
        products_for_agreement_checker =>
          $self->app->product_manager->get_block_accessors_by_page_n_tag($page_accessor_video, 'can_auto_start'),
        login                      => $opts{'--login'},
        from                       => $opts{'--from'},
        starting_email_subject     => gettext('Autostarting video campaigns'),
        not_starting_email_subject => gettext('Autostarting video campaigns: not starting'),
        page_ids                   => $opts{'--page_ids'},
        heartbeat                  => TRUE,
    );

    return TRUE;
}

sub cron_prepare_auto_stop : CRON('0 * * * *') : LOCK {
    my ($self) = @_;

    $self->auto_stop->prepare_auto_stop(
        model => $self->video_an_site,
        products_for_agreement_checker =>
          $self->app->product_manager->get_block_accessors_by_page_n_tag($page_accessor_video, 'can_auto_stop'),
    );

    return TRUE;
}

sub cron_auto_stop : CRON('*/5 * * * *') : LOCK {
    my ($self) = @_;

    $self->auto_stop->do_auto_stop(
        email_subject => gettext('Autostop Video campaigns'),
        model         => $self->video_an_site,
        products_for_agreement_checker =>
          $self->app->product_manager->get_block_accessors_by_page_n_tag($page_accessor_video, 'can_auto_stop'),
    );

    return TRUE;
}

TRUE;
