package Cron::Methods::Assistants;

use qbit;

use base qw(QBit::Cron::Methods);

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB');

sub model_path {'assistants'}

sub check_common_offer : CRON('10 0 * * *') : LOCK : STAGE('PRODUCTION') {
    my ($self) = @_;

    my $filter = [
        AND => [
            [
                page_id => 'IN' => $self->partner_db->query->select(
                    table  => $self->partner_db->all_pages,
                    fields => ['page_id'],
                    filter => [
                        owner_id => 'IN' => $self->partner_db->query->select(
                            table  => $self->partner_db->common_offer_allowed_users,
                            fields => ['user_id'],
                            filter => [
                                'AND' =>
                                  [[deadline => '<' => \curdate(oformat => 'db')], [accept_date => 'IS' => \undef],]
                            ],
                        ),
                    ],
                ),
            ],
            [dissabled => '=' => \0],
        ]
    ];

    $self->partner_db->assistants->edit($self->partner_db->assistants->filter($filter), {dissabled => 1});

    return;
}

1;
