package Cron::Methods::AutoMigrations;

use qbit;

use base qw(QBit::Cron::Methods);
use Utils::MonitoringUtils;
use Utils::Logger qw(INFO INFOF ERROR);
use Utils::MigrationApplier;

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB');

sub model_path {'automigrations'}

# до 4-х утра миграции не применяем, так как в это время идет трансфер БД
sub apply_migrations : CRON('*/5 4-23 * * *') : FRONTEND : STAGE('TEST') : STAGE('PREPROD') : STAGE('AUTOTEST') {
    my ($self) = @_;

    try {
        $self->run_migrations(
            {
                type           => 'mysql',
                order          => 'all',
                without_manual => 1,
                without_prompt => 1,
            }
        );
    }
    catch {
        my ($e) = @_;
        ERROR {
            exception => $e,
            message   => 'Cannot apply migrations',
        };
    };
    return;
}

1;
