package Cron::Methods::BadDomains;

use qbit;

use base qw(QBit::Cron::Methods);

use File::Temp qw(tempfile);

use Utils::Logger qw(INFO);

__PACKAGE__->model_accessors(
    moderation_bad_domains => 'Application::Model::Moderation::BadDomains',
    stat_download_data     => 'Application::Model::StatDownloadData',
);

sub model_path {'bad_domains'}

sub add_baddomains_moderation : CRON('15 * * * *') : LOCK {
    my ($self) = @_;

    INFO "Start fetch data";

    # UNLINK for delete file when object goes out of scope
    my $tmp_path = (tempfile(DIR => $self->get_option('tmp_dir'), UNLINK => 1))[1];

    INFO sprintf('tmp file %s', $tmp_path);

    # TODO: брать время последнего забора из базы
    my $timestamp = time() - 24 * 60 * 60;

    my @columns = qw( PageID  Domain  Hits );
    my $yql     = sprintf '%s from [//yabs/BadDomainsStat] where UpdateTime > %s order by PageID limit 2000000',
      join(', ', @columns), $timestamp;

    $self->app->api_yt->select_from_any_replica(
        replicas => ['seneca-sas', 'seneca-man', 'seneca-myt'],
        path     => '//yabs/BadDomainsStat',
        yql      => $yql,
        headers => {'X-YT-Output-Format' => sprintf('<columns=[%s]>schemaful_dsv', join(';', @columns)),},
        params  => {
            ':content_file' => $tmp_path,
            ':timeout'      => 20,
            ':attempts'     => 3,
            ':delay'        => 0,
        }
    );

    my $size = -s $tmp_path;

    INFO "End fetch data. Fetched $size bytes";

    INFO 'Start process data';

    $self->moderation_bad_domains->process_file($tmp_path);

    INFO 'End process data';

    return 1;
}
