package Cron::Methods::DSP;

use qbit;

use base qw(QBit::Cron::Methods Cron::Methods);

use PiConstants qw($NOTIFICATIONS_YAS_MAIL $GROUP_LEADER_TO_WORK_WITH_INTERNAL_SERVICES);

use Utils::Logger qw(ERROR);

use Exception::BatchFail;

__PACKAGE__->model_accessors(
    context_on_site_rtb          => 'Application::Model::Product::AN::ContextOnSite::RTB',
    dsp                          => 'Application::Model::DSP',
    internal_context_on_site_rtb => 'Application::Model::Product::InternalAN::InternalContextOnSite::RTB',
    mail_notification            => 'Application::Model::MailNotification',
    partner_db                   => 'Application::Model::PartnerDB',
);

sub model_path {'dsp'}

sub check_dsp_states_in_pi_and_bs : CRON('0 3 * * *') : LOCK {
    my ($self) = @_;

    $self->dsp->check_dsp_states_in_pi_and_bs();

    return FALSE;
}

sub create_in_bk : CRON('*/5 * * * *') : LOCK {
    my ($self) = @_;

    $self->cron_action('create_in_bk');
}

sub cron_action {
    my ($self, $action) = @_;

    my $dsps =
      $self->partner_db->dsp->get_all(filter => {multistate => $self->dsp->get_multistate_by_action($action)},);

    my @failed_dsps;
    foreach my $dsp (@$dsps) {
        $self->app->send_heartbeat();

        try {
            $self->dsp->do_action($dsp, $action);
        }
        catch {
            my ($exception) = @_;
            push @failed_dsps, $dsp->{id};
            ERROR $exception;
        };
    }

    if (@failed_dsps) {
        throw Exception::BatchFail sprintf('Failed to do action "%s" for dsps: %s', $action, join(', ', @failed_dsps));
    }
}

sub link_in_balance : CRON('*/5 * * * *') : LOCK {
    my ($self) = @_;

    $self->cron_action('link_in_balance');
}

sub resend_dsp_to_bk : CRON('0 15 * * *') : LOCK : FREQUENCY_LIMIT('1w') : TTL('25h') {
    my ($self) = @_;

    $self->cron_action('resend_to_bk');
}

TRUE;
