package Cron::Methods::LastPayout;

use qbit;

use base qw(QBit::Cron::Methods);

use Utils::Logger qw(INFO ERROR);

sub model_path {'last_payout'}

sub fetch_last_payout : CRON('0 * * * *') : LOCK {
    my ($self) = @_;

    my @columns = qw(client_number period_end_date refresh_date);

    my $data = $self->app->api_yt->read_table_from_any_replica(
        replicas => $self->app->get_option('yt')->{'replicas'},
        path     => '//home/partner/balance/v_partner_service_payments/latest',
        headers  => {
            'X-YT-Output-Format' =>
              sprintf('<columns=[%s];missing_value_mode=print_sentinel>schemaful_dsv', join(';', @columns))
        },
        params => {
            timeout  => 300,
            attempts => 3,
            delay    => 0,
        }
    );

    my $last_date = $self->app->kv_store->get('fetch_last_payout');
    my $refresh_date;

    my %update;
    my @error;
    while ($data =~ /\G(.*)\n/g) {
        my $row_str = $1;
        my %row;
        @row{@columns} = split /\t/, $row_str, 3;

        unless ($row{client_number} and $row{client_number} =~ s/^C(\d+)$/$1/) {
            push @error, $row_str;
            next;
        }
        unless ($update{$row{client_number}} and $update{$row{client_number}}{period_end_date} gt $row{period_end_date})
        {
            $update{$row{client_number}} = \%row;
        }
        unless ($refresh_date) {
            $refresh_date = $row{refresh_date};
        }
    }

    my $make  = 0;
    my $users = $self->app->partner_db->users;
    while (my ($cid, $row) = each %update) {
        next if $last_date and $last_date gt $row->{refresh_date};
        $make += $users->edit($users->filter({client_id => $cid}),
            {last_payout => date_add($row->{period_end_date}, iformat => 'ytnoms', oformat => 'db_time', day => 1)});
    }
    INFO("Make: $make");
    if (@error) {
        splice @error, 10 if @error > 10;
        ERROR("bad client_number format:\n" . join("\n", @error));
    }

    $self->app->kv_store->set('fetch_last_payout', $refresh_date) if $refresh_date;

    return 1;
}

1;
