package Cron::Methods::MDSAvatarsCleanup;

use qbit;

use base qw(QBit::Cron::Methods Cron::Methods);

use Utils::Logger qw(INFO ERROR);

__PACKAGE__->model_accessors(
    mds_avatars               => 'Application::Model::MDSAvatars',
    api_media_storage_avatars => 'QBit::Application::Model::API::Yandex::MediaStorageAvatars',
);

sub model_path {'mds_avatars_cleanup'}

my $REMOVE_HOURS_OLD = 2;

sub cleanup : CRON('11 * * * *') : LOCK {
    my ($self) = @_;

    my $REMOVE_HOURS_OLD = $self->mds_avatars->hours_remove();
    # find orphan records older than $REMOVE_HOURS_OLD hours
    my $records_2delete = $self->mds_avatars->get_orphan_records_older_than($REMOVE_HOURS_OLD);
    my @id_list_2delete;

    INFO "no orphan records older than $REMOVE_HOURS_OLD hours found\n" unless @$records_2delete;

    INFO @$records_2delete . " records found\n" if @$records_2delete;

    foreach my $r2r_x (@$records_2delete) {
        try {
            $self->api_media_storage_avatars->delete_file($r2r_x->{group_id}, $r2r_x->{imagename});
            $self->mds_avatars->partner_db_table()->delete([$r2r_x->{id}]);
        }
        catch {
            ERROR $_[0]->message;
        };
    }
}

TRUE;
