package Cron::Methods::SSP;

use qbit;

use base qw(QBit::Cron::Methods Cron::Methods);

__PACKAGE__->model_accessors(
    kv_store             => 'QBit::Application::Model::KvStore',
    partner_db           => 'Application::Model::PartnerDB',
    ssp_imps             => 'Application::Model::Product::SSP::ImpressionLog',
    ssp_link_mobile_app  => 'Application::Model::Product::SSP::Link::MobileApp',
    ssp_link_context_rtb => 'Application::Model::Product::SSP::Link::ContextRTB',
);

sub model_path {'ssp'}

# update moderation data

my $KV_KEY = 'ssp_lastrun';

sub moderation_update : CRON('0 6,18 * * *') : LOCK {
    my ($self) = @_;

    $self->regular(
        $KV_KEY, 1,
        sub {
            my $date = shift;
            $self->ssp_imps->update_data($date);
            $self->ssp_link_mobile_app->update_data($date);
            $self->ssp_link_context_rtb->update_data($date);
            return 1;
        },
    );

    return FALSE;
}

sub regular {
    my ($self, $kv_name, $window, $code) = @_;

    my $d_cur = curdate(oformat => 'db');
    my $d_last = $self->kv_store->get($kv_name);
    $d_last ||= $d_cur;
    my $d_cur_w = date_sub($d_cur, day => $window, iformat => 'db', oformat => 'db'), my $d_i;

    if (
        compare_dates(
            $d_last,
            $d_cur_w,
            iformat1 => 'db',
            iformat2 => 'db',
        ) <= 0
       )
    {
        $d_i = $d_last;
    } else {
        $d_i = $d_cur_w;
    }

    while (compare_dates($d_i, $d_cur, iformat1 => 'db', iformat2 => 'db') <= 0) {
        $code->($d_i) || last;
        $self->kv_store->set($kv_name, $d_i);
        $d_i = date_add($d_i, day => 1, iformat => 'db', oformat => 'db');
    }

}

sub truncate_ssp_impression_log : CRON('0 6 * * *') : LOCK : STAGE('TEST') : STAGE('PRODUCTION') {
    my ($self) = @_;

    $self->partner_db->update_table(
        'ssp_impression_log',
        sub {
            my ($new_table) = @_;

            my $date = date_sub(curdate(), day => 30, oformat => 'db');
            my $query = $self->partner_db->query->select(
                table  => $self->partner_db->ssp_impression_log,
                filter => ['date', '>=', \$date],
            );
            $new_table->add_multi([$query]);
        }
    );
}

TRUE;
