package Cron::Methods::TNSDict;

use qbit;

use base qw(QBit::Cron::Methods);

use Utils::Logger qw(ERROR INFO INFOF);
use Utils::MonitoringUtils 'send_to_graphite';

use Digest::MD5 qw(md5_hex);
use Time::HiRes qw(gettimeofday tv_interval);

__PACKAGE__->model_accessors(
    tns_dict_brand                    => 'Application::Model::TNSDict::Brand',
    tns_dict_article                  => 'Application::Model::TNSDict::Article',
    api_yt_partner_picategory_mapping => 'QBit::Application::Model::API::Yandex::YT::Partner::CategoryMapping',
    kv_store                          => 'QBit::Application::Model::KvStore',
    partner_db                        => 'Application::Model::PartnerDB',
    all_pages                         => 'Application::Model::AllPages',
);

sub model_path {'tns_dict'}

sub update_tns_dict : CRON('5 */3 * * *') : LOCK : LEASEMEM(10) : FREQUENCY_LIMIT('1d') : TTL('4h') {
    my ($self) = @_;

    foreach (
        qw(
        tns_dict_brand
        tns_dict_article
        )
      )
    {
        try {
            $self->$_->update();
        }
        catch {
            my ($exception) = @_;
            ERROR $exception;
        };
    }

    return TRUE;
}

sub _get_changed_pages {
    my ($app) = @_;

    my $q = $app->partner_db->query->select(
        alias  => 'pc_old',
        table  => $app->partner_db()->picategories,
        fields => {'page_id' => {'page_id' => 'pc_old'}},
      )->left_join(
        alias   => 'pc_new',
        table   => $app->partner_db()->picategories_new,
        fields  => [],
        join_on => [
            AND => [
                [{'page_id'     => 'pc_old'} => '=' => {'page_id'     => 'pc_new'}],
                [{'block_id'    => 'pc_old'} => '=' => {'block_id'    => 'pc_new'}],
                [{'category_id' => 'pc_old'} => '=' => {'category_id' => 'pc_new'}],
            ]
        ],
        filter => [{'page_id' => 'pc_new'} => 'IS' => \undef],
      )->union(
        $app->partner_db->query->select(
            alias  => 'pc_old',
            table  => $app->partner_db()->picategories,
            fields => {'page_id' => {'page_id' => 'pc_new'}},
          )->right_join(
            alias   => 'pc_new',
            table   => $app->partner_db()->picategories_new,
            fields  => [],
            join_on => [
                AND => [
                    [{'page_id'     => 'pc_old'} => '=' => {'page_id'     => 'pc_new'}],
                    [{'block_id'    => 'pc_old'} => '=' => {'block_id'    => 'pc_new'}],
                    [{'category_id' => 'pc_old'} => '=' => {'category_id' => 'pc_new'}],
                ]
            ],
            filter => [{'page_id' => 'pc_old'} => 'IS' => \undef],
          )
      );

    return $q->get_all();
}

TRUE;
