package Cron::Methods::Webmaster;

use qbit;

use base qw(QBit::Cron::Methods);

use Utils::MonitoringUtils 'send_to_graphite';

sub model_path {'webmaster'}

sub export_domains : CRON('*/10 * * * *') : LOCK {
    my ($self) = @_;

    my $domains_site = $self->app->site->get_all(fields => [qw(domain)], filter => {multistate => 'approved'});
    my $domains_internal = $self->app->internal_site->get_all(fields => [qw(domain)]);
    my $domains_video =
      $self->app->video_an_site->get_all(fields => [qw(domain)], filter => {multistate => 'not deleted'});

    my $domains_site_mirrors =
      $self->app->context_on_site_mirrors->get_all(fields => [qw(domain)], filter => {multistate => 'approved'});
    my $domains_internal_mirrors = $self->app->internal_context_on_site_mirrors->get_all(fields => [qw(domain)]);
    my $domains_video_mirrors = $self->app->video_an_site_mirrors->get_all(fields => [qw(domain)]);

    my %domains = (
        (map {$_->{domain} => 'false'} (@$domains_site, @$domains_internal, @$domains_video)),
        (map {$_->{domain} => 'true'} (@$domains_site_mirrors, @$domains_internal_mirrors, @$domains_video_mirrors))
    );

    # yt create table //home/partner/domains_for_webmaster \
    #   --attributes $(cat <<EOF | tr "\n" " " | sed 's| ||g'
    #   {
    #       dynamic=%false;
    #       schema=[
    #         { name=domain; type=string; sort_order=ascending };
    #         { name=is_mirror; type=boolean; required=%true }
    #       ]
    #   }
    #   EOF
    # ) --proxy=hume

    $self->app->api_yt->rewrite_table_on_cluster(
        path => '//home/partner/domains_for_webmaster',
        data => [map {[$_, $domains{$_}]} sort keys %domains],
        column_names => ['domain', 'is_mirror'],
        order_by     => [
            {
                "name"       => "domain",
                "type"       => "string",
                "sort_order" => "asc",
            }
        ],
        params => {
            ':timeout'  => 60,
            ':attempts' => 3,
            ':delay'    => 0,
        }
    );

    send_to_graphite(
        interval => 'five_min',
        path     => 'Webmaster.export_domains',
        value    => scalar keys %domains
    );
}

TRUE;
