package Curses::UI::CommonUTF8;

require Curses::UI::Common;

package Curses::UI::Common;

use strict;

my $rin = '';
my $fno = fileno(STDIN);
$fno = 0 unless $fno >= 0;
vec($rin, $fno, 1) = 1;

sub char_read(;$) {
    my $this      = shift;
    my $blocktime = shift;

    # Initialize the toplevel window for
    # reading a key.
    my $s = $this->root->{-canvasscr};
    noecho();
    raw();
    $s->keypad(1);

    # Read input on STDIN.
    my $key = '-1';
    $blocktime = undef if $blocktime < 0;    # Wait infinite
    my $crin = $rin;
    $! = 0;
    my $found = select($crin, undef, undef, $blocktime);

    if ($found < 0) {
        print STDERR "DEBUG: get_key() -> select() -> $!\n"
          if $Curses::UI::debug;
    } elsif ($found) {
        $key = $s->getch();

        my $c = unpack("C", $key);
        if ($c > 128) {                      # utf8 character is coming
            my @char_utf8 = ($c);            # contains bytes for one symbol in utf8 encoding

            # 6 byte is max for utf8 encoding
            while (length($key) <= 6 and !utf8::decode($key)) {
                my $key_next = $s->getch();
                my $c_next = unpack("C", $key_next);
                push @char_utf8, $c_next;
                $key = pack("C*", @char_utf8);
            }
        }
    }

    return $key;
}

1;
