package Exception::BK::EditPage;

use strict;
use warnings FATAL => 'all';
use utf8;

use base qw(Exception::API::HTTP);

use QBit::StringUtils;
use QBit::GetText;

sub new {
    my ($class, $response) = @_;

    my $self;
    if (ref($response) eq 'SOAP::Lite') {
        my $som = $response->{__CUR_SOM__};

        my $opts = $response->{__OPTS__}->[0];

        my $page_id = $opts->{'0'}->{PageID} // '';

        my $err_msg = sprintf('Got error from banner system. (page_id=%s) ', $page_id);
        if ($som) {
            my $response_data = $som->paramsall;

            if ($response_data && $response_data) {
                if ($response_data->{'Error'}) {
                    $err_msg .= to_json($response_data, canonical => 1);
                } elsif ($response_data->{'0'} && $response_data->{'0'}->{'ErrorStr'}) {
                    $err_msg .= $response_data->{'0'}->{'ErrorStr'};
                }
            }
        }

        $response = $response->transport->http_response();

        $self             = $class->SUPER::new($err_msg);
        $self->{response} = $response;
        $self->{__OPTS__} = $opts;
    } else {
        $self = $class->SUPER::new($response);
    }

    return $self;
}

sub _get_extra_message {
    my ($self) = @_;

    my $opts = $self->{__OPTS__};
    my $message = $opts && %$opts ? " \nData: " . substr(to_json($opts), 0, 1_000) : '';

    return $message;
}

1;
