
=head2 Exception::Balance::IncorrectAnswer::KnownErrors

Исключение возникает в том случае, баланс вернул ошибку, но у ошибки есть
несколько известных видов.

    try {
        throw Exception::Balance::IncorrectAnswer::KnownErrors { error_id => 11, error_text => "Error message" };

    } catch {
        my ($exception) = @_;

        p $exception->get_error_id();           # 11
        p $exception->get_error_text();         # "Error message"

        p $exception->message();                # "Error ID: 11 Error Text: Error message"
        p $exception->as_string();              # big text will all details
    };

=cut

package Exception::Balance::IncorrectAnswer::KnownErrors;
use base qw(Exception::Balance::IncorrectAnswer);

sub as_string {
    my ($self) = shift;

    local $self->{'text'} = $self->message;
    $self->SUPER::as_string(@_);
}

sub get_error_id {
    my ($self) = @_;

    return $self->{'text'}->{'error_id'};
}

sub get_error_text {
    my ($self) = @_;

    return $self->{'text'}->{'error_text'};
}

sub message {
    my ($self) = shift;

    return "Error ID: " . $self->get_error_id . " Error Text: " . $self->get_error_text();
}

1;
