package Exception::CommonOffer;

use strict;
use warnings FATAL => 'all';

use base qw(Exception);

use QBit::GetText;

our %TOKENS = (
    adfox_api_access_1              => d_gettext('Adfox login or password is incorrect'),
    adfox_api_access_10             => d_gettext('Adfox fail authorisation limit exceeded'),
    adfox_api_access_11             => d_gettext('IP address is blocked'),
    adfox_api_access_12             => d_gettext('Adfox account is blocked'),
    adfox_api_access_13             => d_gettext('Adfox account is not owner'),
    adfox_complex                   => d_gettext('Adfox user has complex links'),
    adfox_has_link                  => d_gettext('Adfox user is already linked'),
    adfox_has_paid                  => d_gettext('Adfox user has paid services'),
    adfox_multilink                 => d_gettext('Adfox user has more than one link'),
    adfox_no_client_id              => d_gettext('Adfox client_id is not provided'),
    adfox_no_contract               => d_gettext('Adfox contract is not provided'),
    adfox_no_inn                    => d_gettext('Adfox INN is not found'),
    adfox_not_allowed               => d_gettext('Adfox user is not allowed to fill offer'),
    adfox_other_account_same_uid    => d_gettext('Passport UID is already used by other AdFox account'),
    adfox_other_link                => d_gettext('Adfox user has link with other account'),
    adfox_shared_contract           => d_gettext('Adfox contract has several users'),
    assessor_suspicious_contract    => d_gettext('User already has contract that cannot be reused'),
    ne_inn                          => d_gettext('INNs do not match'),
    unsupported_adfox_contract_type => d_gettext('Unsupported Adfox contract type'),
    unsupported_contract            => d_gettext('Unsupported contract type'),
    user_has_link                   => d_gettext('User is already linked'),
    user_no_client_id               => d_gettext('User has not client_id'),
    user_no_contract                => d_gettext('User has not contract'),
    user_no_inn                     => d_gettext('User has not INN'),
    user_not_allowed                => d_gettext('User is not allowed to fill offer'),
    user_with_contract              => d_gettext('User already has contract'),
);

sub new {
    my ($class, $token, %data) = @_;

    my $text = (!ref $token && $TOKENS{$token} ? $TOKENS{$token}->() : $token);
    my $self = $class->SUPER::new($text, %data);
    if ($TOKENS{$token}) {
        $self->{error_token} = $token;
        $self->{sentry}{fingerprint} = 'common_offer_' . $token;
    }

    $self->{dont_send_to_sentry} = 1;

    return $self;
}

1;
