package IntAPI;

use qbit;

use base qw(QBit::HTTPAPI QBit::WebInterface::FastCGI WebInterface::HTTPS Application);

use IntAPI::Method::StatFace path  => 'statface';
use IntAPI::Method::Devel path     => 'devel';
use IntAPI::Method::DSP path       => 'dsp';
use IntAPI::Method::AWAPS path     => 'awaps';
use IntAPI::Method::BK path        => 'bk';
use IntAPI::Method::AdFox path     => 'adfox';
use IntAPI::Method::Metrika path   => 'metrika';
use IntAPI::Method::YaVideo path   => 'yavideo';
use IntAPI::Method::YaCoTools path => 'yacotools';
use IntAPI::Method::MainPage path  => 'main_page';
use IntAPI::Method::Balance path   => 'balance';
use IntAPI::Method::SearchXML path => 'search_xml';
use IntAPI::Method::AntiFrod path  => 'antifrod';
use IntAPI::Method::Webmaster path => 'webmaster';
use IntAPI::Method::Form path      => 'form';
use IntAPI::Method::Takeout path   => 'takeout';
use IntAPI::Method::IDM path       => 'idm';

__PACKAGE__->config_opts(api_location => 'intapi');

sub get_method {
    my ($self) = @_;
    my ($path, $method, $format) = $self->SUPER::get_method();
    $method =~ s/-/_/g;
    $format = 'json' if $path eq 'idm' and !$format;
    return ($path, $method, $format);
}

sub build_response {
    my ($self) = @_;

    $ENV{SYSTEM} = 'intapi';

    my ($path, $method);
    {
        # Ugly hack: опции не скопированы, т.к. Application::pre_run ещё не вызван
        local ($self->{'__OPTIONS__'}) = clone($self->{'__ORIG_OPTIONS__'});
        ($path, $method) = $self->get_method();
        $self->set_app_locale('ru');
    }

    my $methods = $self->get_methods();
    if ($self->request->scheme() eq 'http') {
        unless ($methods->{$path}{$method}{'attrs'}{'ALLOWHTTP'}) {
            $self->response(QBit::WebInterface::Response->new());
            $self->response->status(301);
            $self->response->location($self->get_https_url());
            return;
        }
    }

    if ($methods->{$path}{$method}{'attrs'}{'ONLYPOST'} and $self->request->method() ne 'POST') {
        $self->response(QBit::WebInterface::Response->new());
        $self->response->status(405);
        return;
    }

    local $QBit::HTTPAPI::SERIALIZERS{'adfox'} = {
        content_type => 'application/json; charset=UTF-8',
        sub          => sub {
            if ($_[0]->{'result'} eq 'ok') {
                return \to_json($_[0]->{'data'}, pretty => $_[1]);
            } elsif ($_[0]->{'result'} eq 'error') {
                return \to_json($_[0], pretty => $_[1]);
            } else {
                throw gettext('Unknown error type "%s"', $_[0]->{'result'});
            }
        },
    };

    return $self->SUPER::build_response();
}

return TRUE;
