package IntAPI::Method;

use qbit;

use base qw(QBit::HTTPAPI::Method);

use Compress::Zlib;
use Utils::Logger qw(ERROR);

use Exception::Denied;
use Exception::Validation::BadArguments;

use PiConstants qw($YNDX_PARTNER_INTAPI_USER_ID $AUTHORIZATION_USER_FIELDS $TVM_HTTP_HEADER_NAME);

__PACKAGE__->model_accessors(
    intapi_acl => 'Application::Model::IntAPI_ACL',
    users      => 'Application::Model::Users',
    api_tvm    => 'Application::Model::API::Yandex::TVM',
);

sub on_error {
    my ($self, $method, $e) = @_;

    if ($self->{'__REQUEST_ID__'}) {
        ERROR sprintf("%s\n%s\n%s",
            $self->{'__REQUEST_ID__'},
            my $end_dt = curdate(oformat => 'db_time'),
            my $error => $e->as_string());
    }
}

sub MODIFY_CODE_ATTRIBUTES {
    my ($package, $sub, @attrs) = @_;

    my %known_attr = (
        'ONLYPOST'      => 1,
        'ALLOWHTTP'     => 1,
        'NO_END_MARKER' => 1,
        'NO_HEADERS'    => 1,
        'NOAUTH'        => 1,
    );

    my @unknown_attrs = ();

    foreach my $attr (@attrs) {
        if ($known_attr{$attr}) {
            $package->_set_method_attr($sub, $attr => TRUE);
        } elsif ($attr =~ /^TVM\s*\((.+)\)\s*$/) {
            my @src = split /\s*,\s*/, $1;
            $package->_set_method_attr($sub, TVM => \@src);
        } else {
            push(@unknown_attrs, $attr);
        }
    }

    return $package->SUPER::MODIFY_CODE_ATTRIBUTES($sub, @unknown_attrs);
}

sub post_run {
    my ($self, $method, $params, $result) = @_;

    if (ref($result) ne 'SCALAR') {
        $result = \'streaming result';
    }
}

sub pre_run {
    my ($self, $method, $params) = @_;

    $self->SUPER::pre_run;

    my $lang = $self->app->request->param('lang') || $self->app->request->http_header('Accept-Language') || 'ru';
    $self->app->set_app_locale($lang);

    my $tvm_valid;
    my $attrs = $self->app->get_methods()->{$self->{'path'}}{$method}{attrs};
    if (my $sources = $attrs->{TVM}) {
        if (defined(my $from = $self->get_tvm_source)) {
            for my $src (@$sources) {
                if ($src eq 'all' or $self->get_option($src, '') eq $from) {
                    $tvm_valid = TRUE;
                    last;
                }
            }
            throw Exception::Denied sprintf("Access is denied with tvm_src '%s'", $from)
              unless $tvm_valid;
        }
    }

    unless ($tvm_valid || $attrs->{NOAUTH}) {
        my @acl = $self->intapi_acl->get_acl_cached($self->{'path'}, $method);

        throw Exception::Denied sprintf('Access is denied from ip %s', $self->app->request->remote_addr)
          unless $self->intapi_acl->check_acl(\@acl, $self->app->request->remote_addr);
    }

    my $tmp_rights =
      $self->app->add_tmp_rights(qw(users_view_all users_view_field__multistate users_view_field__client_id));

    my $user = $self->users->get($YNDX_PARTNER_INTAPI_USER_ID, fields => $AUTHORIZATION_USER_FIELDS);

    $self->app->set_cur_user($user);
}

=head2 get_body

=cut

sub get_body {
    my ($self) = @_;

    return $self->app->request->param_array()->[0];
}

sub get_tvm_source {
    my ($self) = @_;

    my $ticket = $self->app->request->http_header($TVM_HTTP_HEADER_NAME);
    return undef unless $ticket;

    my $result = $self->api_tvm->check_ticket($ticket);
    return 'fail_ticket' unless $result;

    return $result->{src} || 'no_source';
}

TRUE;
