package IntAPI::Method::AWAPS;

use qbit;

use base qw( IntAPI::Method );

use PiConstants qw($TECHNICAL_RTB_BLOCK_ID);

__PACKAGE__->model_accessors(internal_mobile_app => 'Application::Model::Product::InternalAN::MobileApp');

sub rtb_list : METHOD : TITLE('Pages with RTB product') : FORMATS(json, xml, tsv) {
    my ($self, %params) = @_;

    my $tmp_rights = $self->app->add_all_tmp_rights();

    my @rtb_models = qw(
      context_on_site_rtb
      internal_context_on_site_rtb
      mobile_app_rtb
      video_an_site_instream
      );

    my $page_info = {};

    foreach my $model (@rtb_models) {
        my $rtb_model          = $self->app->$model;
        my $page_id_field_name = $rtb_model->get_page_id_field_name();
        my $page_model         = $rtb_model->get_campaign_model();
        my $rtb_blocks         = $rtb_model->get_all(
            fields => [$page_id_field_name, qw(domain multistate page public_id dsps)],
            filter => [
                AND => [
                    [id => '<>' => $TECHNICAL_RTB_BLOCK_ID],
                    (
                        $page_model->get_multistate_by_name('balance_registered')
                        ? [page => MATCH => [multistate => '=' => 'balance_registered']]
                        : ()
                    ),
                ]
            ],
        );

        my $campaign_model = $rtb_model->get_campaign_model_name();

        foreach my $rtb_block (@$rtb_blocks) {
            my $page_id         = $rtb_block->{$page_id_field_name};
            my $block_public_id = $rtb_block->{public_id};

            next unless $rtb_block->{domain};

            $page_info->{$page_id} //= {
                PageID => $page_id,
                Domain => $rtb_block->{domain},
                State  => $self->app->$campaign_model->get_bk_state_name_by_multistate($rtb_block->{page}{multistate}),
                DSP    => {},
                Blocks => {},
            };
            $rtb_block->{dsps} = [] if ref($rtb_block->{dsps}) ne 'ARRAY';
            for my $dsp_id (@{$rtb_block->{dsps}}) {
                # video_an_site_instream returns hash instead of id
                $dsp_id = $dsp_id->{dsp_id} if ref($dsp_id) eq 'HASH';
                $page_info->{$page_id}{DSP}{$dsp_id} = TRUE;
            }
            $page_info->{$page_id}{Blocks}{$block_public_id} = TRUE;
        }
    }

    my $data = [values %$page_info];

    for my $row (@$data) {
        $row->{DSP}    = join(',', sort keys %{$row->{DSP}});
        $row->{Blocks} = join(',', sort keys %{$row->{Blocks}});
    }

    return {
        data    => $data,
        fields  => [qw(PageID Domain State DSP Blocks)],
        options => {with_headers => 1},
    };
}

TRUE;
