package IntAPI::Method::Balance;

use qbit;
use PiConstants ('$AGGR_TUTBY');
use Utils::Stream::DataSource::Query;
use Utils::Stream::DataSource::Map;

use base qw(IntAPI::Method);

__PACKAGE__->model_accessors(
    partner_db      => 'Application::Model::PartnerDB',
    product_manager => 'Application::Model::ProductManager',
);

=head1 billing_report

cм https://wiki.yandex-team.ru/partner/w/partner2-intapi-balance-billing-report/

=cut

sub billing_report : METHOD : ALLOWHTTP : TITLE('Balance billing-report') : STREAM : NO_END_MARKER :
  FORMATS(json, xml, tsv) {
    my ($self, %params) = @_;

    my $external_accessors = $self->product_manager->get_external_product_accessors();

    my $campaigns_query;
    foreach my $accessor (sort @$external_accessors) {
        my $model           = $self->app->$accessor;
        my $page_field_name = $model->get_page_id_field_name();

        my $sub_query = $self->partner_db->query->select(
            table  => $model->partner_db_table(),
            fields => {
                page_id     => $page_field_name,
                create_date => '',
                owner_id    => ''
            },
            (
                $model->get_multistate_by_name('balance_registered')
                ? (filter => {multistate => $model->get_multistates_by_filter('balance_registered')})
                : ()
            ),
        );

        if (defined($campaigns_query)) {
            $campaigns_query->union_all($sub_query);
        } else {
            $campaigns_query = $sub_query;
        }
    }

    my $query = $self->partner_db->query->select(
        table  => $self->partner_db->legacy_billing_report,
        fields => {
            page_id  => '',
            from     => 'date_from',
            to       => 'date_to',
            aggr_uid => 'aggregator_id'
        },
        filter => [aggregator_id => '<>' => \$AGGR_TUTBY->{user_id}]
      )->union_all(
        $self->partner_db->query->select(
            table  => $self->partner_db->users,
            alias  => 'users',
            fields => [],
            filter => {is_tutby => 1},
          )->join(
            table  => $campaigns_query,
            alias  => 'campaigns',
            fields => {
                page_id  => '',
                from     => {DATE_FORMAT => ['create_date' => \'%Y-%m-%d']},
                to       => \undef,
                aggr_uid => \undef,
            },
            join_on => [owner_id => '=' => {'id' => 'users'}],
          )
      );

    my $data_source = Utils::Stream::DataSource::Map->new(
        source => Utils::Stream::DataSource::Query->new(source => $query),
        map    => sub {
            my ($item) = @_;
            $item->{aggr_uid} //= $AGGR_TUTBY->{user_id};
            return $item;
        },
    );

    return {
        fields  => ['page_id', 'from', 'to', 'aggr_uid'],
        data    => $data_source,
        options => {
            without_headers => 0,
            end_marker      => FALSE,
        },
    };
}

1;
