package IntAPI::Method::DSP;

use qbit;

use base qw(IntAPI::Method);

__PACKAGE__->model_accessors(users => 'Application::Model::Users',);

sub is_user : METHOD : PARAMS(!login) : TITLE('Is login dsp partner or dsp manager or developer') : ALLOWHTTP :
  FORMATS(json, xml) {
    my ($self, %opts) = @_;

    my $tmp_rights = $self->app->add_tmp_rights(qw(users_view_all users_view_field__roles));
    my $user = $self->users->get_by_login($opts{'login'}, fields => ['roles']);

    return ($user && grep {$_->{'id'} == 7 || $_->{'id'} == 8 || $_->{'id'} == 2} @{$user->{'roles'} // []}) ? 1 : 0;
}

TRUE;
