package IntAPI::Method::MainPage;

use qbit;

use base qw(IntAPI::Method);

__PACKAGE__->model_accessors(partner_db => 'Application::Model::PartnerDB',);

sub user_id_has_role_in_partner2 : METHOD : PARAMS(user_id) : TITLE('Check user has at least one role in partner2') :
  FORMATS(json, xml) {
    my ($self, %params) = @_;

    my $user_id = $params{user_id};

    my $data = $self->partner_db->user_role->get_all(filter => {user_id => $user_id},);

    return {has_role => (@$data ? 1 : 0),};
}

1;
