package IntAPI::Method::Metrika;

use qbit;

use base qw(IntAPI::Method);

__PACKAGE__->model_accessors(
    mobile_app_settings     => 'Application::Model::Product::AN::MobileApp::Settings',
    internal_mobile_app     => 'Application::Model::Product::InternalAN::MobileApp',
    ssp_mobile_app_settings => 'Application::Model::Product::SSP::MobileApp::Settings',
);

=head2 mobile_page_ids

L<https://wiki.yandex-team.ru/partner/w/partner2-intapi-metrika-mobile-page-ids/>

=cut

sub mobile_page_ids : METHOD : TITLE('Active mobile page ids') : ALLOWHTTP : FORMATS(json, xml, tsv) {
    my ($self, %params) = @_;

    my $tmp_rights = $self->app->add_tmp_rights(
        qw(
          mobile_app_settings_view_all
          internal_mobile_app_view_all
          ssp_mobile_app_settings_view_all
          )
    );

    my @data = ();

    foreach my $model (qw(mobile_app_settings internal_mobile_app ssp_mobile_app_settings)) {
        foreach (
            @{
                $self->$model->get_all(
                    fields => [qw(page_id)],
                    filter => {multistate => 'working or testing'}
                )
            }
          )
        {
            push(@data, {PageID => $_->{'page_id'}});
        }
    }

    return {
        fields  => ['PageID'],
        data    => \@data,
        options => {
            without_headers => 1,
            end_marker      => FALSE,
        },
    };
}

TRUE;
