package IntAPI::Method::SearchXML;

use qbit;
use PiConstants qw(@MAIL_RU_LOGINS);

use base qw(IntAPI::Method);

__PACKAGE__->model_accessors(search_on_site_campaign => 'Application::Model::Product::AN::SearchOnSite::Campaign',);

=head2 camp_report

https://wiki.yandex-team.ru/partner/w/partner2-intapi-search-xml-campreport/

=cut

sub camp_report : METHOD : TITLE('Working search campaigns with xml') : FORMATS(json, xml) {
    my ($self) = @_;

    my $tmp_rights = $self->app->add_all_tmp_rights();

    my $campaigns = $self->search_on_site_campaign->get_all(
        fields => [qw(page_id owner_id domain)],
        filter => {multistate => 'working', yandex_xml => 1}
    );

    my %mail_ru_page_ids     = map {$_ => 1} $self->_get_search_page_ids_owned_by_logins(@MAIL_RU_LOGINS);
    my %rambler_page_ids     = map {$_ => 1} $self->_get_search_page_ids_owned_by_logins('rambler-p');
    my %microsoft_page_ids   = map {$_ => 1} $self->_get_search_page_ids_owned_by_logins('microsoft-partner');
    my %drive2_page_ids      = map {$_ => 1} $self->_get_search_page_ids_owned_by_logins('drive2russia');
    my %tutbysearch_page_ids = map {$_ => 1} $self->_get_search_page_ids_owned_by_logins('tutbysearch');

    my %allow_ads_with_search_additional_pages = map {$_ => 1} qw(444190 444191);    # PI-17648

    # PI-20596 / DPA-167
    my %pages = map {$_ => 1} 582716, 582834, 582835, 582712, 581829, 582428, 582432, 582429, 582433, 593769, 597507,
      747888, 747889;

    foreach my $campaign (@$campaigns) {
        $campaign->{'user_id'} = delete($campaign->{'owner_id'});

        my $page_id = $campaign->{page_id};
        if ($mail_ru_page_ids{$page_id} || $microsoft_page_ids{$page_id}) {
            $campaign->{allow_ads} = 1;
            $campaign->{allow_ads_with_search} = 1 if $allow_ads_with_search_additional_pages{$page_id};
        } elsif ($rambler_page_ids{$page_id}
            || $drive2_page_ids{$page_id}
            || $tutbysearch_page_ids{$page_id}
            || $pages{$page_id})
        {
            $campaign->{allow_ads}             = 1;
            $campaign->{allow_ads_with_search} = 1;
        }
    }

    return $campaigns;
}

sub _get_search_page_ids_owned_by_logins {
    my ($self, @logins) = @_;

    throw Exception 'Must specify @logins)' unless @logins;

    my @canonical_logins;

    foreach my $l (@logins) {
        push @canonical_logins, fix_login($l);
    }

    my @user_ids = map {$_->{id}} @{
        $self->app->users->get_all(
            fields => [qw(id)],
            filter => {login => \@canonical_logins},
        )
      };

    my @page_ids = map {$_->{page_id}} @{
        $self->search_on_site_campaign->get_all(
            fields => [qw(page_id)],
            filter => {owner_id => \@user_ids},
        )
      };

    return @page_ids;
}

TRUE;
