package IntAPI::Method::StatFace;

=encoding UTF-8

=cut

use qbit;

use base qw(IntAPI::Method);

__PACKAGE__->model_accessors(
    bk_statistics                     => 'Application::Model::BKStatistics',
    internal_context_on_site_campaign => 'Application::Model::Product::InternalAN::InternalContextOnSite::Campaign',
    internal_search_on_site_campaign  => 'Application::Model::Product::InternalAN::InternalSearchOnSite::Campaign',
);

=head2 external_an_page_ids

https://wiki.yandex-team.ru/partner/w/partner2-intapi-statface-external-an-page-ids/

=cut

sub external_an_page_ids : METHOD : TITLE('List of external AN pages with domains') : FORMATS(json, xml) {
    my ($self) = @_;

    my $tmp_rights = $self->app->add_all_tmp_rights();

    my %domain_pages;
    foreach (
        map {{id => $_->{'context_page_id'}, domain => $_->{'store_id'}}}
        @{$self->app->mobile_app_settings->get_all(fields => [qw(context_page_id store_id)])},
      )
    {
        $domain_pages{$_->{'domain'}}->{$_->{'id'}} = TRUE;
    }

    my %res;
    foreach my $domain (keys(%domain_pages)) {
        $res{$domain} = [sort keys(%{$domain_pages{$domain}})];
    }

    return \%res;
}

=head2 internal_an_page_ids

https://wiki.yandex-team.ru/partner/w/partner2-intapi-statface-internal-an-page-ids/

=cut

sub internal_an_page_ids : METHOD : TITLE('List of internal AN pages with domains') : FORMATS(json, xml) {
    my ($self) = @_;

    my $tmp_rights = $self->app->add_tmp_rights(
        qw(
          internal_context_on_site_campaign_view_all
          internal_search_on_site_campaign_view_all
          internal_mobile_app_view_all
          )
    );

    my %domain_pages;
    foreach (
        @{$self->internal_context_on_site_campaign->get_all(fields => [qw(id domain)])},
        @{$self->internal_search_on_site_campaign->get_all(fields => [qw(id domain)])},
        map {{id => $_->{'id'}, domain => $_->{'store_id'}}}
        @{$self->app->internal_mobile_app->get_all(fields => [qw(id store_id)])},
      )
    {
        $domain_pages{$_->{'domain'}}->{$_->{'id'}} = TRUE;
    }

    my %res;
    foreach my $domain (keys(%domain_pages)) {
        $res{$domain} = [sort keys(%{$domain_pages{$domain}})];
    }

    return \%res;
}

=head2 money_by_products

https://wiki.yandex-team.ru/partner/w/partner2-intapi-statface-money-by-products/

=cut

sub money_by_products : METHOD : PARAMS(from, to) : TITLE('Money by product page_id') : FORMATS(json, xml) {
    my ($self, %opts) = @_;

    $opts{'from'} ||= curdate(oformat => 'db');
    $opts{'to'}   ||= curdate(oformat => 'db');

    my $tmp_rights = $self->app->add_all_tmp_rights();

    my $data = {
        # context
        advnet_context_on_site_content => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'advnet_context_on_site_content'}],
            fields           => [qw(content_block_shows content_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'context_on_site_content',
        },
        advnet_context_on_site_natural => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'advnet_context_on_site_natural'}],
            fields           => [qw(natural_block_shows natural_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'context_on_site_natural',
        },
        advnet_context_on_site_rtb => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'advnet_context_on_site_rtb'}],
            fields           => [qw(rtb_block_shows rtb_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'context_on_site_rtb',
        },
        advnet_context_on_site_direct => {
            period => [$opts{'from'}, $opts{'to'}],
            levels => [{id => 'advnet_context_on_site_direct'}],
            fields           => [qw(direct_context_shows direct_context_clicks direct_context_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'context_on_site_direct',
        },
        advnet_context_on_site_mcb => {
            period => [$opts{'from'}, $opts{'to'}],
            levels => [{id => 'advnet_context_on_site_mcb'}],
            fields           => [qw(mcb_context_shows mcb_context_clicks mcb_context_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'context_on_site_mcb',
        },
        advnet_context_on_site_market => {
            period => [$opts{'from'}, $opts{'to'}],
            levels => [{id => 'advnet_context_on_site_market'}],
            fields           => [qw(market_context_shows market_context_clicks market_context_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'context_on_site_market',
        },
        advnet_context_on_site_market_api => {
            period => [$opts{'from'}, $opts{'to'}],
            levels => [{id => 'advnet_context_on_site_market_api'}],
            fields           => [qw(market_api_context_shows market_api_context_clicks market_api_context_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'context_on_site_market_api',
        },
        advnet_context_on_site_stripe => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'advnet_context_on_site_stripe'}],
            fields           => [qw(stripe_shows stripe_clicks stripe_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'context_on_site_stripe',
        },
        advnet_context_on_site_adblock => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'advnet_context_on_site_adblock'}],
            fields           => [qw(adblock_block_shows adblock_all_w_nds)],
            entity_fields    => [qw(page_id domain)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'context_on_site_adblock',
        },
        # search
        advnet_search_on_site_premium => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'advnet_search_on_site_premium'}],
            fields           => [qw(premium_shows premium_clicks premium_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'search_on_site_premium',
        },
        advnet_search_on_site_direct => {
            period => [$opts{'from'}, $opts{'to'}],
            levels => [{id => 'advnet_search_on_site_direct'}],
            fields           => [qw(direct_search_shows direct_search_clicks direct_search_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            block_model      => 'search_on_site_direct',
        },
        advnet_search_on_site_mcb => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'advnet_search_on_site_mcb'}],
            fields           => [qw(mcb_search_shows mcb_search_clicks mcb_search_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'search_on_site_mcb',
        },
        advnet_search_on_site_market => {
            period => [$opts{'from'}, $opts{'to'}],
            levels => [{id => 'advnet_search_on_site_market'}],
            fields           => [qw(market_search_shows market_search_clicks market_search_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'search_on_site_market',
        },
        advnet_search_on_site_market_api => {
            period => [$opts{'from'}, $opts{'to'}],
            levels => [{id => 'advnet_search_on_site_market_api'}],
            fields           => [qw(market_api_search_shows market_api_search_clicks market_api_search_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'search_on_site_market_api',
        },
        # mobile
        mobile_app_rtb => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'mobile_app_rtb'}],
            fields           => [qw(mobile_rtb_block_shows mobile_rtb_all_w_nds)],
            entity_fields    => [qw(page_id store_id)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'mobile_app_rtb',
        },
        # video
        video_an_site_instream => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'video_an_site_instream'}],
            fields           => [qw(instream_block_shows instream_all_w_nds)],
            entity_fields    => [qw(page_id domain)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'video_an_site_instream',
        },
        video_an_site_inpage => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'video_an_site_inpage'}],
            fields           => [qw(inpage_block_shows inpage_all_w_nds)],
            entity_fields    => [qw(page_id domain)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'video_an_site_inpage',
        },
        video_an_site_fullscreen => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'video_an_site_fullscreen'}],
            fields           => [qw(fullscreen_block_shows fullscreen_all_w_nds)],
            entity_fields    => [qw(page_id domain)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'video_an_site_fullscreen',
        },
        # internal context
        internal_advnet_context_on_site_rtb => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'internal_advnet_context_on_site_rtb'}],
            fields           => [qw(rtb_block_shows rtb_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'internal_context_on_site_rtb',
        },
        internal_advnet_context_on_site_direct => {
            period => [$opts{'from'}, $opts{'to'}],
            levels => [{id => 'internal_advnet_context_on_site_direct'}],
            fields           => [qw(direct_context_shows direct_context_clicks direct_context_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'internal_context_on_site_direct',
        },
        internal_advnet_context_on_site_stripe => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'internal_advnet_context_on_site_stripe'}],
            fields           => [qw(stripe_shows stripe_clicks stripe_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'internal_context_on_site_stripe',
        },
        internal_advnet_context_on_site_natural => {
            period => [$opts{'from'}, $opts{'to'}],
            levels => [{id => 'internal_advnet_context_on_site_natural'}],
            fields           => [qw(natural_block_shows natural_block_clicks natural_block_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'internal_context_on_site_natural',
        },
        internal_advnet_context_on_site_content => {
            period => [$opts{'from'}, $opts{'to'}],
            levels => [{id => 'internal_advnet_context_on_site_content'}],
            fields           => [qw(content_block_shows content_block_clicks content_block_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'internal_context_on_site_content',
        },
        # internal search
        internal_advnet_search_on_site_premium => {
            period => [$opts{'from'}, $opts{'to'}],
            levels => [{id => 'internal_advnet_search_on_site_premium'}],
            fields           => [qw(premium_shows premium_clicks premium_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'internal_search_on_site_premium',
        },
        internal_advnet_search_on_site_direct => {
            period => [$opts{'from'}, $opts{'to'}],
            levels => [{id => 'internal_advnet_search_on_site_direct'}],
            fields           => [qw(direct_search_shows direct_search_clicks direct_search_all_w_nds)],
            entity_fields    => [qw(campaign_id domain)],
            dimension_fields => [qw(date)],
            total            => 0,
            block_model      => 'internal_search_on_site_direct',
        },
        # internal mobile
        internal_mobile_app_rtb => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'internal_mobile_app_rtb'}],
            fields           => [qw(mobile_rtb_block_shows mobile_rtb_all_w_nds)],
            entity_fields    => [qw(page_id store_id)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'internal_mobile_app_rtb',
        },
        # SSP
        ssp_mobile_app_rtb => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'ssp_mobile_app_rtb'}],
            fields           => [qw(ssp_mobile_rtb_block_shows ssp_mobile_rtb_all_w_nds)],
            entity_fields    => [qw(page_id bundle_id)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'ssp_mobile_app_rtb',
        },
        ssp_video_app_rtb => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'ssp_video_app_rtb'}],
            fields           => [qw(rtb_block_shows rtb_all_w_nds)],
            entity_fields    => [qw(page_id bundle_id)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'ssp_video_an_site_rtb',
        },
        ssp_context_rtb_rtb => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'ssp_context_rtb_rtb'}],
            fields           => [qw(rtb_block_shows rtb_all_w_nds)],
            entity_fields    => [qw(page_id domain)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'ssp_context_on_site_rtb',
        },
        # DOOH
        indoor_block => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'indoor_block'}],
            fields           => [qw(indoor_block_shows indoor_all_w_nds)],
            entity_fields    => [qw(page_id domain)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'indoor_block',
        },
        outdoor_block => {
            period => [$opts{'from'}, $opts{'to'}],
            levels           => [{id => 'outdoor_block'}],
            fields           => [qw(outdoor_block_shows outdoor_all_w_nds)],
            entity_fields    => [qw(page_id domain)],
            dimension_fields => [qw(date dsp_id_name dsp_caption)],
            total            => 0,
            block_model      => 'outdoor_block',
        },
    };

    my $r;
    foreach my $k (sort keys %$data) {
        my $params        = $data->{$k};
        my $product_level = $params->{block_model};
        next unless $product_level;

        my $name_page_id = $self->app->$product_level->get_page_id_field_name();
        unless (grep {$_ =~ /$name_page_id/} @{$params->{entity_fields}}) {
            $name_page_id = 'page_id';
        }
        my $tr_fields = {
            page_id     => $name_page_id,
            domain      => [grep {$_ !~ /$name_page_id/} @{$params->{entity_fields}}]->[0],
            dsp_id      => 'dsp_id_name',
            dsp_caption => 'dsp_caption',
            date        => 'date',
            shows       => [grep {$_ =~ /_shows/} @{$params->{fields}}]->[0],
            all_wo_nds  => [grep {$_ =~ /_nds/} @{$params->{fields}}]->[0],
        };
        if (grep {$_ =~ m/_clicks/} @{$params->{fields}}) {
            $tr_fields->{clicks_direct} = [grep {$_ =~ m/_clicks/} @{$params->{fields}}]->[0];
        }

        my @fields = qw(shows all_wo_nds);
        push @fields, 'clicks_direct' if (grep {$_ =~ /click/} @{$params->{fields}});

        my $answer = $self->bk_statistics->get_statistics2(
            period => [$opts{'from'}, $opts{'to'}],
            levels => [{filter => ['AND', [['block_level', 'IN', [$product_level]]]], id => 'payment'}],
            fields => \@fields,
            entity_fields    => [qw(page_id domain dsp_id dsp_caption)],
            dimension_fields => [qw(date|day)],
            total            => 0,
        );

        my @t;
        foreach my $point (@{$answer->{points}}) {
            push @t,
              {
                hash_transform(
                    {%{$point->{measures}[0]}, (%{$point->{dimensions}}, (date => $point->{dimensions}{date}[0]))},
                    [sort keys %$tr_fields], $tr_fields
                ),
                currency_id => 2
              };
        }
        $r->{$params->{levels}[0]{id}} = \@t;
    }

    $data = $r;

    # for compatibility
    $_->{'ssp_bundle_id'} = delete $_->{'bundle_id'} foreach @{$data->{ssp_mobile_app_rtb}};

    return $data;
}

sub pages : METHOD : TITLE('List of all pages with domains') : FORMATS(json, xml) {
    my ($self) = @_;

    my %domain_pages;

    foreach (
        @{
            $self->app->all_pages->get_all(
                fields => [qw(page_id domain product_type is_yandex_page business_unit is_ssp)]
            )
        }
      )
    {
        $domain_pages{$_->{'domain'}} //= [];
        push @{$domain_pages{$_->{'domain'}}}, $_;
    }

    return \%domain_pages;
}

TRUE;
