package IntAPI::Method::Takeout;

use qbit;
use Exception::Denied;
use Utils::Logger qw(INFOF INFO);

use base qw(IntAPI::Method);

my @takeout_fields_user = qw(
  login
  name
  lastname
  midname
  email
  phone
  country_id
  create_date
  );

my @takeout_fields_site = qw(
  domain
  );

my @takeout_fields_app = qw(
  store_id
  store_url
  );

__PACKAGE__->model_accessors(
    partner_db => 'Application::Model::PartnerDB',
    api_tvm    => 'Application::Model::API::Yandex::TVM',
);

sub takeout : METHOD : ALLOWHTTP : PARAMS(!uid, !unixtime) : TVM(tvm_app_takeout) : FORMATS(json) :
  TITLE('Takeout data') {
    my ($self, %params) = @_;

    my $tmp_rights = $self->app->add_all_tmp_rights();

    throw Exception::Validation::BadArguments gettext("user_id is not numeric: %s", $params{uid})
      unless $params{uid} =~ /^[0-9]+$/;
    throw Exception::Validation::BadArguments gettext("unixtime is not numeric: %s", $params{unixtime})
      unless $params{unixtime} =~ /^[0-9]+$/;

    return $self->_get_data($params{uid});
}

sub _get_data {
    my ($self, $uid) = @_;

    my $data = {status => 'no_data'};
    my $result = $self->app->users->get($uid, fields => \@takeout_fields_user);
    if ($result) {
        $data->{status} = "ok";
        $data->{data}{'pi_user.json'} = to_json($result, canonical => TRUE);

        $data->{data}{'pi_sites.json'} = to_json(
            $self->app->site->get_all(
                fields => \@takeout_fields_site,
                filter => ['login', 'MATCH', ['user_id', '=', $uid]],
            ),
            canonical => TRUE
        );

        $data->{data}{'pi_apps.json'} = to_json(
            $self->app->mobile_app->get_all(
                fields => \@takeout_fields_app,
                filter => ['owner', 'MATCH', ['user_id', '=', $uid]],
            ),
            canonical => TRUE
        );
    }

    my @ret = (to_json($data, canonical => TRUE));
    return sub {
        my @r = splice @ret, 0;
        return \@r;
    };
}

1;
