package IntAPI::Method::Webmaster;

use qbit;
use QBit::Validator;

use base qw(IntAPI::Method);

__PACKAGE__->model_accessors(
    partner_db                   => 'Application::Model::PartnerDB',
    context_on_site_rtb          => 'Application::Model::Product::AN::ContextOnSite::RTB',
    internal_context_on_site_rtb => 'Application::Model::Product::InternalAN::InternalContextOnSite::RTB',
);

=head1 get_turbo

L<https://wiki.yandex-team.ru/partner/w/partner2-intapi-webmaster-get-turbo/>

=cut

sub get_turbo : METHOD : PARAMS(!block_id,!page_id) : TITLE('Turbo block status') : FORMATS(json, xml) {
    my ($self, %params) = @_;

    my $block_id = $params{'block_id'};
    my $page_id  = $params{'page_id'};

    foreach (qw(block_id page_id)) {
        throw Exception::Validation::BadArguments gettext('option "%s" must consist of digits', $_)
          if $params{$_} !~ /^[0-9]+\z/;
    }

    my $block = $self->partner_db->context_on_site_rtb->get_all(
        fields => {page_id => 'campaign_id', block_id => 'id', site_version => ''},
        filter => [
            'AND',
            [
                ['campaign_id', '=', \$page_id],
                ['id',          '=', \$block_id],
                [
                    'OR',
                    [
                        [
                            'AND',
                            [
                                ['model',      '=',  \'context_on_site_rtb'],
                                ['multistate', 'IN', \$self->context_on_site_rtb->get_multistates_by_filter('working')]
                            ]
                        ],
                        [
                            'AND',
                            [
                                ['model', '=', \'internal_context_on_site_rtb'],
                                [
                                    'multistate', 'IN',
                                    \$self->internal_context_on_site_rtb->get_multistates_by_filter('working')
                                ]
                            ]
                        ],
                    ]
                ]
            ]
        ]
    )->[0];

    unless ($block) {
        return {error => 'block not found'};
    }

    $block->{'turbo'} = delete($block->{'site_version'}) eq 'turbo' ? JSON::XS::true() : JSON::XS::false();

    return $block;
}

=head1 get_turbo_v2

L<https://wiki.yandex-team.ru/partner/w/partner2-intapi-webmaster-get-turbo_v2/>

=cut

sub get_turbo_v2 : METHOD : PARAMS(!block_id,!page_id) : TITLE('Block site_version with direct_format and media_size') :
  FORMATS(json, xml) {

    my ($self, %params) = @_;

    my $block_id = $params{'block_id'};
    my $page_id  = $params{'page_id'};

    foreach (qw(block_id page_id)) {
        throw Exception::Validation::BadArguments gettext('option "%s" must consist of digits', $_)
          if $params{$_} !~ /^[0-9]+\z/;
    }

    my $tmp_rights = $self->app->add_all_tmp_rights();

    my $block;
    foreach my $model (qw(context_on_site_rtb internal_context_on_site_rtb)) {
        $block = $self->$model->get_all(
            fields => [qw(page_id id site_version direct_block media_block)],
            filter => {page_id => $page_id, id => $block_id, multistate => 'working'}
        )->[0];

        last if $block;
    }

    unless ($block) {
        return {error => 'block not found'};
    }

    $block->{'block_id'}      = delete($block->{'id'});
    $block->{'direct_format'} = delete($block->{'direct_block'});
    $block->{'media_size'}    = delete($block->{'media_block'});

    return $block;
}

TRUE;
