package IntAPI::Method::YaCoTools;

use qbit;

use base qw(IntAPI::Method);

=head2 domains_report

L<https://wiki.yandex-team.ru/partner/w/partner2-intapi-yacotools-domains-report/>

=cut

sub domains_report : METHOD : TITLE('Domains report') : FORMATS(json, xml, tsv) {
    my ($self) = @_;

    my $data                         = [];
    my $app                          = $self->app;
    my $campaign_models_with_mirrors = $app->product_manager->get_page_model_accessors();
    my $tmp_rights                   = $self->app->add_all_tmp_rights();

    foreach my $campaign_model (@$campaign_models_with_mirrors) {
        my $model_fields = $app->$campaign_model->get_model_fields();

        next unless exists($model_fields->{'domain'});

        my $is_bundle_id =
          grep {$campaign_model eq $_} qw(ssp_video_an_site ssp_mobile_app_settings mobile_app_settings);

        my $page_id_field_name = $app->$campaign_model->get_page_id_field_name();

        my $multistates = $app->$campaign_model->get_multistate_names();

        my $campaigns = $app->$campaign_model->get_all(
            fields => [grep {exists($model_fields->{$_})} $page_id_field_name, qw(domain mirrors multistate)],
            filter => {multistate => join(' or ', grep {$multistates->{$_}} qw(testing working))}
        );

        foreach my $campaign (@$campaigns) {
            if (   $campaign->{'domain'}
                && $campaign->{$page_id_field_name})
            {
                delete $campaign->{'multistate'};
                $campaign->{'page_id'} = delete $campaign->{$page_id_field_name};
                my @mirrors = @{delete($campaign->{'mirrors'}) // []};
                @mirrors = map {$_->{'domain'}} @mirrors if ref($mirrors[0]) eq 'HASH';
                $campaign->{'domains'} = [];
                foreach my $raw_domain_or_bundle_id (delete $campaign->{'domain'}, @mirrors) {
                    # PI-10870 - bundle_id does not satisfy domain RFC
                    my $domain =
                      $is_bundle_id ? $raw_domain_or_bundle_id : get_domain($raw_domain_or_bundle_id, ascii => 1);
                    push @{$campaign->{'domains'}}, $domain // '';
                }
                $campaign->{'domains'} = join ',', @{$campaign->{'domains'}};
                push @$data, $campaign;
            }
        }
    }

    return {
        data         => $data,
        fields       => [qw(page_id domains)],
        with_headers => 1
    };
}

TRUE;
