package IntAPI::Method::YaVideo;

use qbit;

use base qw(IntAPI::Method);

use URI;

__PACKAGE__->model_accessors(
    video_an_site_instream   => 'Application::Model::Product::VideoAN::Site::InStream',
    video_an_site            => 'Application::Model::Page::Video',
    video_an_site_categories => 'Application::Model::Product::VideoAN::Site::Categories',
);

sub get_pages_for_ya_video : METHOD : TITLE('Info about pages') : FORMATS(json, xml) {
    my ($self) = @_;

    my $tmp_rights = $self->app->add_tmp_rights(qw(video_an_site_instream_view_all video_an_site_view_all));

    my @page_ids = map {$_->{'page_id'}} @{
        $self->video_an_site_instream->get_all(
            fields => ['page_id'],
            filter => {multistate => 'not deleted and working', category_id => [1000, 1001]}
        )
      };

    my $sites = $self->video_an_site->get_all(
        fields => [qw(id caption domain mirrors data_pixels partner_type)],
        filter => {id => \@page_ids}
    );

    foreach my $row (@$sites) {
        $row->{'page_id'} = delete($row->{'id'});

        my $domain  = delete($row->{'domain'});
        my $mirrors = delete($row->{'mirrors'});

        $row->{'hosts'} = [$domain, grep {$_ ne $domain} @$mirrors];

        my $data_pixels = delete($row->{'data_pixels'});

        my @pixels = ();
        foreach my $cat_id (keys(%$data_pixels)) {
            foreach my $pixel (@{$data_pixels->{$cat_id}}) {
                next if $pixel->{'url'} eq '';

                my $url = URI->new($pixel->{'url'})->canonical;

                my @query = $url->query_form();

                push(@query, 'page_id', $row->{'page_id'}, 'pixel_type', $pixel->{'type'});

                $url->query_form(@query);

                push(
                    @pixels,
                    {
                        position_type => $self->video_an_site_categories->get_position_type_by_category_id($cat_id),
                        pixel_type    => $pixel->{'type'},
                        url           => $url . '&position_id=%position_id%&request=%request%&host=%host%&url=%url%'
                    }
                );
            }
        }

        $row->{'pixels'} = \@pixels;
    }

    return $sites;
}

TRUE;
