package Partner::BlockPreset::Component::Articles;

use qbit;

use base qw(Partner::BlockPreset::Component);

use Partner::BlockPreset::Specification::Articles;

sub init {
    my ($self) = @_;

    $self->{'specification'} = Partner::BlockPreset::Specification::Articles->new();
}

sub settings {
    my ($self) = @_;

    my $settings = $self->SUPER::settings;

    return {articles => to_json($settings->{'articles'})};
}

sub get_filter {
    my ($self, $model) = @_;

    # unavailable
    return FALSE
      unless $model->DOES('Application::Model::Role::Has::Articles');

    # available
    return undef;
}

sub get_patch {
    my ($self, $model) = @_;

    my $settings = $self->settings();

    my %patch = (articles => $settings->{'articles'},);

    return %patch;
}

TRUE;
