package Partner::BlockPreset::Component::Brands;

use qbit;

use base qw(Partner::BlockPreset::Component);

use Partner::BlockPreset::Specification::Brands;

sub init {
    my ($self) = @_;

    $self->{'specification'} = Partner::BlockPreset::Specification::Brands->new();
}

sub get_filter {
    my ($self, $model) = @_;

    # unavailable
    return FALSE unless $model->DOES('Application::Model::Role::Has::Brands');

    # available
    return undef;
}

sub get_patch {
    my ($self, $model) = @_;

    my $settings = $self->settings();

    my %patch = (brands => $settings->{'brands'},);

    return %patch;
}

TRUE;
