package Partner::BlockPreset::Component::Geo;

use qbit;

use base qw(Partner::BlockPreset::Component);

use Partner::BlockPreset::Specification::Geo;

sub init {
    my ($self) = @_;

    $self->{'specification'} = Partner::BlockPreset::Specification::Geo->new();
}

sub settings {
    my ($self) = @_;

    my $settings = $self->SUPER::settings;

    return {geo => to_json($settings->{'geo'}, canonical => TRUE)};
}

sub get_filter {
    my ($self, $model) = @_;

    # unavailable
    return FALSE unless $model->DOES('Application::Model::Role::Has::Geo');

    # available
    return undef;
}

sub get_patch {
    my ($self, $model) = @_;

    my $settings = $self->settings();

    my %patch = (geo => $settings->{'geo'},);

    return %patch;
}

TRUE;
