package Partner::BlockPreset::Component::PICategories;

use qbit;

use base qw(Partner::BlockPreset::Component);

use Partner::BlockPreset::Specification::PICategories;

sub init {
    my ($self) = @_;

    $self->{'specification'} = Partner::BlockPreset::Specification::PICategories->new();
}

sub settings {
    my ($self) = @_;

    my $settings = $self->SUPER::settings;

    return {picategories => $settings->{'picategories'}};
}

sub get_filter {
    my ($self, $model) = @_;

    # unavailable
    return FALSE
      unless $model->DOES('Application::Model::Role::Block::Has::PICategories');

    # available
    return undef;
}

sub get_patch {
    my ($self, $model) = @_;

    my $settings = $self->settings();

    my %patch = (picategories => $settings->{'picategories'},);

    return %patch;
}

TRUE;
