package Partner::BlockPreset::Component::Strategies;

use qbit;

use base qw(Partner::BlockPreset::Component);

use Partner::BlockPreset::Specification::Strategies;

use PiConstants qw(
  $MIN_CPM_STRATEGY_ID
  $MAX_REVENUE_STRATEGY_ID
  $SEPARATE_CPM_STRATEGY_ID
  );

sub init {
    my ($self) = @_;

    $self->{'specification'} = Partner::BlockPreset::Specification::Strategies->new(
        specification => {
            $MIN_CPM_STRATEGY_ID      => {},
            $MAX_REVENUE_STRATEGY_ID  => {},
            $SEPARATE_CPM_STRATEGY_ID => {fields => [qw(text media video)]},
        }
    );
}

sub get_filter {
    my ($self, $model) = @_;

    my $settings = $self->settings();

    # unavailable
    return FALSE unless $model->can('get_strategies');

    my $strategies = $model->get_strategies();

    if (   $strategies->{$settings->{'strategy'}}
        && $strategies->{$settings->{'strategy'}}{'applicable_to'}{'model_filter'})
    {
        # limit
        return $strategies->{$settings->{'strategy'}}{'applicable_to'}{'model_filter'};
    } elsif ($strategies->{$settings->{'strategy'}}) {
        # available
        return undef;
    } else {
        # unavailable
        return FALSE;
    }
}

sub get_patch {
    my ($self, $model) = @_;

    my $settings = $self->settings();

    my %patch = (
        strategy => $settings->{'strategy'},
        mincpm   => $settings->{'mincpm'},
    );

    #перетащить это в декларативное описание в sub get_strategies
    my @fields_for_separated_strategy = ();
    if ($model->isa('Application::Model::Block::Video')) {
        @fields_for_separated_strategy = (['video', 'media'], ['video-performance', 'text']);
    } else {
        @fields_for_separated_strategy = (['media', 'media'], ['text', 'text']);
    }

    foreach my $fields (@fields_for_separated_strategy) {
        foreach (qw(_active _blocked _cpm)) {
            $patch{$fields->[0] . $_} = $settings->{$fields->[1] . $_};
        }
    }

    return %patch;
}

sub get_non_applicable_seperate_cpm_strategy_fields {
    my @fields;
    for my $suffix (qw(active blocked cpm)) {
        push @fields, map {$_ . '_' . $suffix} qw(video);
    }
    return @fields;
}

TRUE;
